/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.bizprocessors.common.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.bizprocessors.common.dao.GmDevTermDao;
import com.iesms.bizprocessors.common.entity.GmDevTermDo;
import com.iesms.bizprocessors.common.request.GmDevTermGetRequest;
import com.iesms.bizprocessors.common.response.GmDevTermGetResponse;
import com.iesms.bizprocessors.common.service.AbstractIesmsBaseService;
import com.iesms.bizprocessors.common.service.GmDevTermService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GmDevTermServiceImpl
extends AbstractIesmsBaseService
implements GmDevTermService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GmDevTermDao gmDevTermDao;

    @Autowired
    public GmDevTermServiceImpl(GmDevTermDao gmDevTermDao) {
        this.gmDevTermDao = gmDevTermDao;
    }

    public GmDevTermGetResponse getGmDevTerm(GmDevTermGetRequest gmDevTermGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start getGmDevTerm >>>>>> ");
            this.logger.debug(" GmDevTermGetRequest          : " + JsonConvertUtils.convertToString((Object)gmDevTermGetRequest));
        }
        GmDevTermGetResponse gmDevTermGetResponse = new GmDevTermGetResponse();
        gmDevTermGetResponse.setFailureDefault();
        GmDevTermDo gmDevTerm = null;
        if (gmDevTermGetRequest != null && gmDevTermGetRequest.getDevTermId() != null && gmDevTermGetRequest.getDevTermId() > 0L) {
            gmDevTerm = (GmDevTermDo)this.gmDevTermDao.get(gmDevTermGetRequest.getDevTermId());
        } else if (gmDevTermGetRequest != null && StringUtils.isNotBlank((CharSequence)gmDevTermGetRequest.getOrgNo())) {
            if (StringUtils.isNotBlank((CharSequence)gmDevTermGetRequest.getDevTermNo())) {
                gmDevTerm = this.gmDevTermDao.getByOrgNoAndDevTermNo(gmDevTermGetRequest.getOrgNo(), gmDevTermGetRequest.getDevTermNo());
            } else if (StringUtils.isNotBlank((CharSequence)gmDevTermGetRequest.getDevTermCommProto()) && StringUtils.isNotBlank((CharSequence)gmDevTermGetRequest.getDevTermCommAddr())) {
                gmDevTerm = this.gmDevTermDao.getByOrgNoAndDevTermCommProtoAndDevTermCommAddr(gmDevTermGetRequest.getOrgNo(), gmDevTermGetRequest.getDevTermCommProto(), gmDevTermGetRequest.getDevTermCommAddr());
            }
        } else if (gmDevTermGetRequest != null && gmDevTermGetRequest.getAccessGatewayId() != null && gmDevTermGetRequest.getAccessGatewayId() > 0L) {
            gmDevTerm = this.gmDevTermDao.getByAccessGatewayId(gmDevTermGetRequest.getAccessGatewayId());
        }
        if (gmDevTerm == null) {
            gmDevTermGetResponse.setFailure("GM_DEV_TERM_NOTEXIST", "\u8be5\u91c7\u96c6\u7ec8\u7aef\u8bbe\u5907\u4e0d\u5b58\u5728");
        } else {
            gmDevTermGetResponse.setSuccess();
            gmDevTermGetResponse.setGmDevTerm(gmDevTerm);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" GmDevTermGetResponse            : " + JsonConvertUtils.convertToString((Object)gmDevTermGetResponse));
            this.logger.debug(" <<<<<<< end getGmDevTerm <<<<<<< ");
        }
        return gmDevTermGetResponse;
    }
}

