package com.iesms.bizprocessors.common.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.common.dao.GmDevMeterDao;
import com.iesms.bizprocessors.common.dao.GmopsDevMeterDao;
import com.iesms.bizprocessors.common.entity.GmDevMeterDo;
import com.iesms.bizprocessors.common.entity.GmopsDevMeterDo;
import com.iesms.bizprocessors.common.request.GmopsDevMeterBatchRefreshRequest;
import com.iesms.bizprocessors.common.request.GmopsDevMeterRefreshRequest;
import com.iesms.bizprocessors.common.response.GmopsDevMeterBatchRefreshResponse;
import com.iesms.bizprocessors.common.response.GmopsDevMeterRefreshResponse;
import com.iesms.bizprocessors.common.service.AbstractIesmsBaseService;
import com.iesms.bizprocessors.common.service.GmopsDevMeterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 *
 */
@Service(value = "gmopsDevMeterServiceImpl")
public class GmopsDevMeterServiceImpl extends AbstractIesmsBaseService implements GmopsDevMeterService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private GmDevMeterDao gmDevMeterDao;
    private GmopsDevMeterDao gmopsDevMeterDao;

    @Autowired
    public GmopsDevMeterServiceImpl(GmDevMeterDao gmDevMeterDao, GmopsDevMeterDao gmopsDevMeterDao) {
        this.gmDevMeterDao = gmDevMeterDao;
        this.gmopsDevMeterDao = gmopsDevMeterDao;
    }

    @Override
    public GmopsDevMeterRefreshResponse refreshGmopsDevMeter(GmopsDevMeterRefreshRequest gmopsDevMeterRefreshRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start refreshGmopsDevMeter >>>>>> ");
            logger.debug(" GmopsDevMeterRefreshRequest  : " + JsonConvertUtils.convertToString(gmopsDevMeterRefreshRequest));
        }
        GmopsDevMeterRefreshResponse gmopsDevMeterRefreshResponse = new GmopsDevMeterRefreshResponse();
        gmopsDevMeterRefreshResponse.setFailureDefault();
        GmopsDevMeterDo gmopsDevMeter = null;
        if(gmopsDevMeterRefreshRequest != null && gmopsDevMeterRefreshRequest.getDevMeterId() != null && gmopsDevMeterRefreshRequest.getDevMeterId() > 0L) {
            gmopsDevMeter = gmopsDevMeterDao.getByDevMeterId(gmopsDevMeterRefreshRequest.getDevMeterId());
        }

        if(gmopsDevMeter == null) {
            GmDevMeterDo gmDevMeter = null;
            if(gmopsDevMeterRefreshRequest != null && gmopsDevMeterRefreshRequest.getDevMeterId() != null && gmopsDevMeterRefreshRequest.getDevMeterId() > 0L) {
                gmDevMeter = gmDevMeterDao.get(gmopsDevMeterRefreshRequest.getDevMeterId());
            }
            if(gmDevMeter != null) {
                gmopsDevMeter = new GmopsDevMeterDo();
                gmopsDevMeter.setId(idGenerator.nextId());
                gmopsDevMeter.setDevMeterId(gmDevMeter.getId());
                gmopsDevMeter.setGmtMessageUp(gmopsDevMeterRefreshRequest.getGmtMessageUp() != null ? gmopsDevMeterRefreshRequest.getGmtMessageUp() : 0L);
                gmopsDevMeter.setGmtMeasdataUp(gmopsDevMeterRefreshRequest.getGmtMeasdataUp() != null ? gmopsDevMeterRefreshRequest.getGmtMeasdataUp() : 0L);
                gmopsDevMeter.setGmtAlarmUp(gmopsDevMeterRefreshRequest.getGmtAlarmUp() != null ? gmopsDevMeterRefreshRequest.getGmtAlarmUp() : 0L);
                gmopsDevMeter.setGmtReadingUp(gmopsDevMeterRefreshRequest.getGmtReadingUp() != null ? gmopsDevMeterRefreshRequest.getGmtReadingUp() : 0L);
                gmopsDevMeter.setReadingValue(gmopsDevMeterRefreshRequest.getReadingValue());
                gmopsDevMeter.setMeterStateOpen(gmopsDevMeterRefreshRequest.getMeterStateOpen() != null ? gmopsDevMeterRefreshRequest.getMeterStateOpen() : 0);
                gmopsDevMeter.setMeasDataInfoSet(gmopsDevMeterRefreshRequest.getMeasDataInfoSet() != null ? gmopsDevMeterRefreshRequest.getMeasDataInfoSet() : "{}");
                gmopsDevMeter.setValid(true);
                gmopsDevMeter.setCreator("IESMS_BP");
                gmopsDevMeter.setGmtCreate(System.currentTimeMillis());
                gmopsDevMeter.setModifier("IESMS_BP");
                gmopsDevMeter.setGmtModified(System.currentTimeMillis());
                gmopsDevMeter.setInvalider("");
                gmopsDevMeter.setGmtInvalid(0L);
                gmopsDevMeter.setVersion(1);
                if(logger.isDebugEnabled()) {
                    logger.debug("insert gmopsDevMeter : " + JsonConvertUtils.convertToString(gmopsDevMeter));
                }
                gmopsDevMeterDao.insert(gmopsDevMeter);
            }
        }
        else {
            if(gmopsDevMeterRefreshRequest.getGmtMessageUp() != null) {
                gmopsDevMeter.setGmtMessageUp(gmopsDevMeterRefreshRequest.getGmtMessageUp());
            }
            if(gmopsDevMeterRefreshRequest.getGmtMeasdataUp() != null) {
                gmopsDevMeter.setGmtMeasdataUp(gmopsDevMeterRefreshRequest.getGmtMeasdataUp());
            }
            if(gmopsDevMeterRefreshRequest.getGmtAlarmUp() != null) {
                gmopsDevMeter.setGmtAlarmUp(gmopsDevMeterRefreshRequest.getGmtAlarmUp());
            }
            if(gmopsDevMeterRefreshRequest.getGmtReadingUp() != null) {
                gmopsDevMeter.setGmtReadingUp(gmopsDevMeterRefreshRequest.getGmtReadingUp());
            }
            if(gmopsDevMeterRefreshRequest.getReadingValue() != null) {
                gmopsDevMeter.setReadingValue(gmopsDevMeterRefreshRequest.getReadingValue());
            }
            if(gmopsDevMeterRefreshRequest.getMeterStateOpen() != null) {
                gmopsDevMeter.setMeterStateOpen(gmopsDevMeterRefreshRequest.getMeterStateOpen());
            }
            if(gmopsDevMeterRefreshRequest.getMeasDataInfoSet() != null) {
                String getMeasDataInfoSetOld = gmopsDevMeter.getMeasDataInfoSet();
                String getMeasDataInfoSetNew = gmopsDevMeterRefreshRequest.getMeasDataInfoSet();
                Map<String, Object> getMeasDataInfoSetOldMap = JsonConvertUtils.convertFromString(getMeasDataInfoSetOld, Map.class);
                Map<String, Object> getMeasDataInfoSetNewMap = JsonConvertUtils.convertFromString(getMeasDataInfoSetNew, Map.class);
                Map<String, Object> getMeasDataInfoSetMap = Maps.newHashMap();
                if(getMeasDataInfoSetOldMap != null) {
                    getMeasDataInfoSetMap.putAll(getMeasDataInfoSetOldMap);
                }
                if(getMeasDataInfoSetNewMap != null) {
                    getMeasDataInfoSetMap.putAll(getMeasDataInfoSetNewMap);
                }
                gmopsDevMeter.setMeasDataInfoSet(JsonConvertUtils.convertToString(getMeasDataInfoSetMap));
            }
            gmopsDevMeter.setModifier("IESMS_BP");
            gmopsDevMeter.setGmtModified(System.currentTimeMillis());
            //logger.info("update gmopsDevMeter : " + JsonConvertUtils.convertToString(gmopsDevMeter));
            gmopsDevMeterDao.update(gmopsDevMeter);
        }
        gmopsDevMeterRefreshResponse.setSuccess();
        gmopsDevMeterRefreshResponse.setGmopsDevMeter(gmopsDevMeter);

        if(logger.isDebugEnabled()) {
            logger.debug(" GmopsDevMeterRefreshResponse : " + JsonConvertUtils.convertToString(gmopsDevMeterRefreshResponse));
            logger.debug(" <<<<<<< end refreshGmopsDevMeter <<<<<<< ");
        }
        return gmopsDevMeterRefreshResponse;
    }

    @Override
    public GmopsDevMeterBatchRefreshResponse batchRefreshGmopsDevMeter(GmopsDevMeterBatchRefreshRequest gmopsDevMeterBatchRefreshRequest) {
        return null;
    }
}
