package com.iesms.bizprocessors.common.util;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import com.easesource.iot.datacenter.openservice.request.MeasDataLatestGetRequest;
import com.easesource.iot.datacenter.openservice.response.MeasDataLatestGetResponse;
import com.iesms.bizprocessors.common.entity.SoeDevMeterAlarmVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MeasStatUtil {
    /***
     * @Author ghl
     * @描述 获取累计量日统计数据（单个日期）
     * @Param [sets, measPointId, dateMeasStat, measStatService]
     * @return com.easesource.iot.datacenter.openservice.response.MeasStatCumDayGetResponse
     **/
    public static MeasDataLatestGetResponse getMeasStatCumDayValue(Set<String> measItemCodeSet, Long measPointId, MeasDataService measDataService) {
        // 量测点发电量查询（量测统计数据）
        MeasDataLatestGetRequest getRequest = new MeasDataLatestGetRequest();
        getRequest.setMeasPointId(measPointId);
        getRequest.setMeasDataSideType(1);
        getRequest.setMeasItemCodeSet(measItemCodeSet);
        MeasDataLatestGetResponse response = measDataService.getMeasDataLatest(getRequest);
        return response;
    }

    /**
     * 获取量测项集合
     *
     * @param devMeterAlarmList
     * @return
     */
    public static Set<String> getMeasIdList(List<SoeDevMeterAlarmVo> devMeterAlarmList) {
        Map<String, Long> measMaps = new ConcurrentHashMap<>();
        devMeterAlarmList.forEach(meterAlarmVo -> {
            Long measPointId = meterAlarmVo.getMeasPointId();
            String measPointIds = meterAlarmVo.getMeasPointIdList();
            String[] measPointIds2 = null;
            if (measPointIds != null && !measPointIds.equals("[]") && !measPointIds.equals("[0]")) {
                measPointIds2 = JsonConvertUtils.convertFromString(measPointIds, String[].class);
            }
            if (measPointIds2 != null && measPointIds2.length > 0) {
                for (String measId : measPointIds2) {
                    measMaps.put(measId, Long.valueOf(measId));
                }
            }
            if (measPointId != null) {
                measMaps.put(measPointId.toString(), measPointId);
            }
        });
        Set<String> strings = measMaps.keySet();
        return strings;
    }

    /**
     * 调用接口，获取数据并将相同数据项的数据求和，
     * 如果是电压，功率因数，温度则取最大值和最小值
     * gen_watt_u gen_watt_temp gen_watt_pf
     *
     * @param measItemCodeSet
     * @param measIdList
     * @param measDataService
     * @return
     */
    public static Map<String, BigDecimal> getValueSum(Set<String> measItemCodeSet, Set<String> measIdList, MeasDataService measDataService) {
        Map<String, BigDecimal> valueMap = new ConcurrentHashMap<>();
        measIdList.forEach(measPointId -> {
            MeasDataLatestGetResponse getResponse = getMeasStatCumDayValue(measItemCodeSet, Long.valueOf(measPointId), measDataService);
            if (getResponse != null && getResponse.isSuccess()) {
                Map<String, MeasDataLatestInfo> measDataMap = getResponse.getMeasDataMap();
                measItemCodeSet.forEach(itemCode -> {
                    MeasDataLatestInfo dataLatestInfo = measDataMap.get(itemCode);
                    if (dataLatestInfo == null) {
                        return;
                    }
                    Object measDataValue = dataLatestInfo.getMeasDataValue();
                    if (measDataValue == null) {
                        return;
                    }
                    String value = measDataValue.toString();
                    if (value.equals("0E-8")) {
                        value = "0.0";
                    }
                    BigDecimal valueDecimal = new BigDecimal(value);
                    if (valueMap.containsKey(itemCode)) {
                        if (itemCode.startsWith("gen_watt_temp") || itemCode.startsWith("gen_watt_u") || itemCode.startsWith("gen_watt_pf")) {
                            // 取最大值
                            BigDecimal bigDecimal = valueMap.get(itemCode);
                            int i = bigDecimal.compareTo(valueDecimal);
                            if (i < 0) {
                                valueMap.put(itemCode, valueDecimal);
                            }
                        } else {
                            // 相加
                            if (valueMap.containsKey(itemCode)) {
                                BigDecimal bigDecimal = valueMap.get(itemCode);
                                BigDecimal decimal = bigDecimal.add(valueDecimal);
                                valueMap.put(itemCode, decimal);
                            }
                        }
                    } else {
                        valueMap.put(itemCode, valueDecimal);
                    }
                });
            }
        });
        return valueMap;
    }

    /**
     * 数据去除小数点后多余的 0
     *
     * @param s
     * @return
     */
    public static String subZeroAndDot(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(".") > 0) {
            // 去掉多余的0
            s = s.replaceAll("0+?$", "");
            // 如最后一位是.则去掉
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }
}
