/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.bizprocessors.common.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.bizprocessors.common.dao.GmDevMeterDao;
import com.iesms.bizprocessors.common.entity.GmDevMeterDo;
import com.iesms.bizprocessors.common.entity.GmDevMeterVo;
import com.iesms.bizprocessors.common.request.GmDevMeterGetRequest;
import com.iesms.bizprocessors.common.response.GmDevMeterGetResponse;
import com.iesms.bizprocessors.common.service.AbstractIesmsBaseService;
import com.iesms.bizprocessors.common.service.GmDevMeterService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GmDevMeterServiceImpl
extends AbstractIesmsBaseService
implements GmDevMeterService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GmDevMeterDao gmDevMeterDao;

    @Autowired
    public GmDevMeterServiceImpl(GmDevMeterDao gmDevMeterDao) {
        this.gmDevMeterDao = gmDevMeterDao;
    }

    public GmDevMeterGetResponse getGmDevMeter(GmDevMeterGetRequest gmDevMeterGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start getGmDevMeter >>>>getDevMeterByDevMeterCommAddr>> ");
            this.logger.debug(" GmDevMeterGetRequest         : " + JsonConvertUtils.convertToString((Object)gmDevMeterGetRequest));
        }
        GmDevMeterGetResponse gmDevMeterGetResponse = new GmDevMeterGetResponse();
        gmDevMeterGetResponse.setFailureDefault();
        GmDevMeterVo gmDevMeter = null;
        if (gmDevMeterGetRequest != null && gmDevMeterGetRequest.getDevMeterId() != null && gmDevMeterGetRequest.getDevMeterId() > 0L) {
            gmDevMeter = this.gmDevMeterDao.getGmDevMeterVo(gmDevMeterGetRequest.getDevMeterId());
        } else if (gmDevMeterGetRequest != null && StringUtils.isNotBlank((CharSequence)gmDevMeterGetRequest.getOrgNo())) {
            if (StringUtils.isNotBlank((CharSequence)gmDevMeterGetRequest.getDevMeterNo())) {
                gmDevMeter = this.gmDevMeterDao.getGmDevMeterVoByOrgNoAndDevMeterNo(gmDevMeterGetRequest.getOrgNo(), gmDevMeterGetRequest.getDevMeterNo());
            } else if (StringUtils.isNotBlank((CharSequence)gmDevMeterGetRequest.getDevMeterCommProto()) && StringUtils.isNotBlank((CharSequence)gmDevMeterGetRequest.getDevMeterCommAddr())) {
                gmDevMeter = this.gmDevMeterDao.getGmDevMeterVoByOrgNoAndDevMeterCommProtoAndDevMeterCommAddr(gmDevMeterGetRequest.getOrgNo(), gmDevMeterGetRequest.getDevMeterCommProto(), gmDevMeterGetRequest.getDevMeterCommAddr());
            }
        } else if (gmDevMeterGetRequest != null && gmDevMeterGetRequest.getAccessMeasureId() != null && gmDevMeterGetRequest.getAccessMeasureId() > 0L) {
            gmDevMeter = this.gmDevMeterDao.getGmDevMeterVoByAccessMeasureId(gmDevMeterGetRequest.getAccessMeasureId());
        } else if (gmDevMeterGetRequest != null && gmDevMeterGetRequest.getMeasPointId() != null && gmDevMeterGetRequest.getMeasPointId() > 0L) {
            gmDevMeter = this.gmDevMeterDao.getGmDevMeterVoByMeasPointId(gmDevMeterGetRequest.getMeasPointId());
        }
        if (gmDevMeter == null) {
            gmDevMeterGetResponse.setFailure("GM_DEV_METER_NOTEXIST", "\u8be5\u91cf\u6d4b\u8868\u8ba1\u8bbe\u5907\u4e0d\u5b58\u5728");
        } else {
            gmDevMeterGetResponse.setSuccess();
            gmDevMeterGetResponse.setGmDevMeter(gmDevMeter);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" GmDevMeterGetResponse            : " + JsonConvertUtils.convertToString((Object)gmDevMeterGetResponse));
            this.logger.debug(" <<<<<<< end getGmDevMeter <<<<<<< ");
        }
        return gmDevMeterGetResponse;
    }

    public GmDevMeterGetResponse getGmDevMeterByMeasPointId(Long measPointId) {
        GmDevMeterGetResponse gmDevMeterGetResponse = new GmDevMeterGetResponse();
        gmDevMeterGetResponse.setFailureDefault();
        GmDevMeterVo gmDevMeter = this.gmDevMeterDao.getGmDevMeterBymeasPointId(measPointId);
        if (gmDevMeter == null) {
            gmDevMeterGetResponse.setFailure("GM_DEV_METER_NOTEXIST", "\u8be5\u91cf\u6d4b\u8868\u8ba1\u8bbe\u5907\u4e0d\u5b58\u5728");
        } else {
            gmDevMeterGetResponse.setSuccess();
            gmDevMeterGetResponse.setGmDevMeter(gmDevMeter);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean BrushGmDevMeter(String mac) {
        try {
            List<GmDevMeterDo> gmDevMeterDoList = this.gmDevMeterDao.getGmDevMeterByDevTermCommAddr(mac);
            if (CollectionUtil.isEmpty(gmDevMeterDoList)) {
                this.logger.debug("\u8868\u8ba1gmdevmeter\u672a\u5efa\u7acb,return false!!!");
                return false;
            }
            gmDevMeterDoList.forEach(gmDevMeterDo -> {
                if (gmDevMeterDo.getAccessMeasureId() == 0L) {
                    gmDevMeterDo.setAccessMeasureId(Long.valueOf(this.idGenerator.nextId()));
                }
                if (gmDevMeterDo.getMeasPointId() == 0L) {
                    gmDevMeterDo.setMeasPointId(Long.valueOf(this.idGenerator.nextId()));
                }
                this.gmDevMeterDao.updateMeasurePointIds((GmDevMeterDo)gmDevMeterDo);
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<GmDevMeterDo> gmDevMeterDoList(String mac) {
        List<GmDevMeterDo> gmDevMeterDoList = this.gmDevMeterDao.getGmDevMeterByDevTermCommAddr(mac);
        return gmDevMeterDoList;
    }
}

