package com.iesms.bizprocessors.common.dao;

import com.iesms.bizprocessors.common.entity.SoeDevMeterAlarmVo;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDto;
import com.iesms.bizprocessors.common.entity.SoeThresholdSetAlarmDo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface SoeRecordOnOffAlarmDao {

    /**
     * 告警插入
     *
     * @param soeRecordOnOffAlarmDo
     */
    void insertSoeRecordOnOffAlarmDo(@Param("params") SoeRecordOnOffAlarmDo soeRecordOnOffAlarmDo);


    /**
     * 告警插入
     *
     * @param soeRecordOnOffAlarmDto
     */
    void insertSoeRecordOnOffAlarmDto(@Param("params") SoeRecordOnOffAlarmDto soeRecordOnOffAlarmDto);


    /**
     * 更新告警
     *
     * @param params
     */
    void updateSoeRecordOnOffAlarmDo(@Param("params") SoeRecordOnOffAlarmDo params);

    /**
     * 更新告警
     *
     * @param params
     */
    void updateSoeRecordOnOffAlarmDto(@Param("params") SoeRecordOnOffAlarmDto params);

    /**
     * 查询最新的未复归的告警信息
     *
     * @param params
     * @return
     */
    SoeRecordOnOffAlarmDo getSoeRecordOnOffAlarmDo(@Param("params") Map<String, Object> params);

    /**
     * 查询最新的未复归的告警信息
     *
     * @param params
     * @return
     */
    SoeRecordOnOffAlarmDto getSoeRecordOnOffAlarmDto(@Param("params") Map<String, Object> params);

    /**
     * 根据表计地址和终端网关地址表计标识
     *
     * @param map
     * @return
     */
    SoeRecordOnOffAlarmDo getDevMeterInfo(@Param("params") Map<String, String> params);

    /**
     * 根据表计地址和量测项标识查询表计信息
     *
     * @param map
     * @return
     */
    SoeRecordOnOffAlarmDo getDevMeterInfoByMeasePointId(@Param("params") Map<String, String> params);
    /**
     * 查询上下限设置
     *
     * @return
     */
    List<SoeThresholdSetAlarmDo> getSoeThresholdSetAlarmDo();

    /**
     * 查询设备和量测项信息
     *
     * @param vo
     * @return
     */
    List<SoeDevMeterAlarmVo> getSoeDevMeterAlarmList(SoeDevMeterAlarmVo vo);

    /**
     * 查找量测点相关的设备信息
     *
     * @param vo
     * @return
     */
    List<SoeThresholdSetAlarmDo> getAlarmMsg(SoeDevMeterAlarmVo vo);
}
