package com.iesms.bizprocessors.common.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.bizprocessors.common.dao.GmDevMeterDao;
import com.iesms.bizprocessors.common.entity.GmDevMeterDo;
import com.iesms.bizprocessors.common.entity.GmDevMeterVo;
import com.iesms.bizprocessors.common.request.GmDevMeterGetRequest;
import com.iesms.bizprocessors.common.response.GmDevMeterGetResponse;
import com.iesms.bizprocessors.common.service.AbstractIesmsBaseService;
import com.iesms.bizprocessors.common.service.GmDevMeterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 */
@Service
public class GmDevMeterServiceImpl extends AbstractIesmsBaseService implements GmDevMeterService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private GmDevMeterDao gmDevMeterDao;

    @Autowired
    public GmDevMeterServiceImpl(GmDevMeterDao gmDevMeterDao) {
        this.gmDevMeterDao = gmDevMeterDao;
    }

    @Override
    public GmDevMeterGetResponse getGmDevMeter(GmDevMeterGetRequest gmDevMeterGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getGmDevMeter >>>>getDevMeterByDevMeterCommAddr>> ");
            logger.debug(" GmDevMeterGetRequest         : " + JsonConvertUtils.convertToString(gmDevMeterGetRequest));
        }
        GmDevMeterGetResponse gmDevMeterGetResponse = new GmDevMeterGetResponse();
        gmDevMeterGetResponse.setFailureDefault();
        GmDevMeterVo gmDevMeter = null;
        if(gmDevMeterGetRequest != null && gmDevMeterGetRequest.getDevMeterId() != null && gmDevMeterGetRequest.getDevMeterId() > 0L) {
            gmDevMeter = gmDevMeterDao.getGmDevMeterVo(gmDevMeterGetRequest.getDevMeterId());
        }
        else if(gmDevMeterGetRequest != null && StringUtils.isNotBlank(gmDevMeterGetRequest.getOrgNo())) {
            if(StringUtils.isNotBlank(gmDevMeterGetRequest.getDevMeterNo())) {
                gmDevMeter = gmDevMeterDao.getGmDevMeterVoByOrgNoAndDevMeterNo(gmDevMeterGetRequest.getOrgNo(), gmDevMeterGetRequest.getDevMeterNo());
            }
            else if(StringUtils.isNotBlank(gmDevMeterGetRequest.getDevMeterCommProto()) && StringUtils.isNotBlank(gmDevMeterGetRequest.getDevMeterCommAddr())) {
                gmDevMeter = gmDevMeterDao.getGmDevMeterVoByOrgNoAndDevMeterCommProtoAndDevMeterCommAddr(gmDevMeterGetRequest.getOrgNo(), gmDevMeterGetRequest.getDevMeterCommProto(), gmDevMeterGetRequest.getDevMeterCommAddr());
            }
        }
        else if(gmDevMeterGetRequest != null && gmDevMeterGetRequest.getAccessMeasureId() != null && gmDevMeterGetRequest.getAccessMeasureId() > 0L) {
            gmDevMeter = gmDevMeterDao.getGmDevMeterVoByAccessMeasureId(gmDevMeterGetRequest.getAccessMeasureId());
        }
        else if(gmDevMeterGetRequest != null && gmDevMeterGetRequest.getMeasPointId() != null && gmDevMeterGetRequest.getMeasPointId() > 0L) {
            gmDevMeter = gmDevMeterDao.getGmDevMeterVoByMeasPointId(gmDevMeterGetRequest.getMeasPointId());
        }

        if(gmDevMeter == null) {
            gmDevMeterGetResponse.setFailure("GM_DEV_METER_NOTEXIST", "该量测表计设备不存在");
        }
        else {
            gmDevMeterGetResponse.setSuccess();
            gmDevMeterGetResponse.setGmDevMeter(gmDevMeter);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" GmDevMeterGetResponse            : " + JsonConvertUtils.convertToString(gmDevMeterGetResponse));
            logger.debug(" <<<<<<< end getGmDevMeter <<<<<<< ");
        }
        return gmDevMeterGetResponse;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean BrushGmDevMeter(String mac) {
        try {





            List<GmDevMeterDo> gmDevMeterDoList = gmDevMeterDao.getGmDevMeterByDevTermCommAddr(mac);
            if (CollectionUtil.isEmpty(gmDevMeterDoList)){
                logger.debug("表计gmdevmeter未建立,return false!!!");
                return false;
            }
            gmDevMeterDoList.forEach(gmDevMeterDo -> {
                if (gmDevMeterDo.getAccessMeasureId() == 0) {
                    gmDevMeterDo.setAccessMeasureId(idGenerator.nextId());
                }
                if (gmDevMeterDo.getMeasPointId() == 0) {
                    gmDevMeterDo.setMeasPointId(idGenerator.nextId());
                }
                gmDevMeterDao.updateMeasurePointIds(gmDevMeterDo);
            });
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<GmDevMeterDo> gmDevMeterDoList(String mac) {
        List<GmDevMeterDo> gmDevMeterDoList = gmDevMeterDao.getGmDevMeterByDevTermCommAddr(mac);
        return gmDevMeterDoList;
    }
}
