package com.iesms.bizprocessors.common.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.iesms.bizprocessors.common.entity.GmDevMeterDo;
import com.iesms.bizprocessors.common.entity.GmDevMeterVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
public interface GmDevMeterDao extends CrudMapper<GmDevMeterDo, Long> {

    GmDevMeterDo getByOrgNoAndDevMeterNo(@Param("orgNo") String orgNo, @Param("devMeterNo") String devMeterNo);

    GmDevMeterDo getByOrgNoAndDevMeterCommProtoAndDevMeterCommAddr(@Param("orgNo") String orgNo, @Param("devMeterCommProto") String devMeterCommProto, @Param("devMeterCommAddr") String devMeterCommAddr);

    GmDevMeterDo getByAccessMeasureId(@Param("accessMeasureId") Long accessMeasureId);

    GmDevMeterDo getByMeasPointId(@Param("measPointId") Long measPointId);

    GmDevMeterVo getGmDevMeterVo(Long id);

    GmDevMeterVo getGmDevMeterVoByOrgNoAndDevMeterNo(@Param("orgNo") String orgNo, @Param("devMeterNo") String devMeterNo);

    GmDevMeterVo getGmDevMeterVoByOrgNoAndDevMeterCommProtoAndDevMeterCommAddr(@Param("orgNo") String orgNo, @Param("devMeterCommProto") String devMeterCommProto, @Param("devMeterCommAddr") String devMeterCommAddr);

    GmDevMeterVo getGmDevMeterVoByAccessMeasureId(@Param("accessMeasureId") Long accessMeasureId);

    GmDevMeterVo getGmDevMeterVoByMeasPointId(@Param("measPointId") Long measPointId);

    List<GmDevMeterVo> getGmDevMeterVoList(@Param("addrSet") Set<String> addrSet);

    List<GmDevMeterDo>  getGmDevMeterByDevTermCommAddr(@Param("devTermCommAddr") String devTermCommAddr);

    int updateMeasurePointIds(GmDevMeterDo gmDevMeterDo);
}
