package com.iesms.bizprocessors.common.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.bizprocessors.common.dao.GmDevTermDao;
import com.iesms.bizprocessors.common.dao.GmopsDevTermDao;
import com.iesms.bizprocessors.common.entity.GmDevTermDo;
import com.iesms.bizprocessors.common.entity.GmopsDevTermDo;
import com.iesms.bizprocessors.common.request.GmopsDevTermRefreshRequest;
import com.iesms.bizprocessors.common.response.GmopsDevTermRefreshResponse;
import com.iesms.bizprocessors.common.service.AbstractIesmsBaseService;
import com.iesms.bizprocessors.common.service.GmopsDevTermService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 *
 */
@Service(value = "gmopsDevTermServiceImpl")
public class GmopsDevTermServiceImpl extends AbstractIesmsBaseService implements GmopsDevTermService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private GmDevTermDao gmDevTermDao;
    private GmopsDevTermDao gmopsDevTermDao;

    @Autowired
    public GmopsDevTermServiceImpl(GmDevTermDao gmDevTermDao, GmopsDevTermDao gmopsDevTermDao) {
        this.gmDevTermDao = gmDevTermDao;
        this.gmopsDevTermDao = gmopsDevTermDao;
    }

    @Override
    public GmopsDevTermRefreshResponse refreshGmopsDevTerm(GmopsDevTermRefreshRequest gmopsDevTermRefreshRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start refreshGmopsDevTerm >>>>>> ");
            logger.debug(" GmopsDevTermRefreshRequest   : " + JsonConvertUtils.convertToString(gmopsDevTermRefreshRequest));
        }
        GmopsDevTermRefreshResponse gmopsDevTermRefreshResponse = new GmopsDevTermRefreshResponse();
        gmopsDevTermRefreshResponse.setFailureDefault();
        GmopsDevTermDo gmopsDevTerm = null;
        if(gmopsDevTermRefreshRequest != null && gmopsDevTermRefreshRequest.getDevTermId() != null && gmopsDevTermRefreshRequest.getDevTermId() > 0L) {
            gmopsDevTerm = gmopsDevTermDao.getByDevTermId(gmopsDevTermRefreshRequest.getDevTermId());
        }

        if(gmopsDevTerm == null) {
            GmDevTermDo gmDevTerm = null;
            if(gmopsDevTermRefreshRequest != null && gmopsDevTermRefreshRequest.getDevTermId() != null && gmopsDevTermRefreshRequest.getDevTermId() > 0L) {
                gmDevTerm = gmDevTermDao.get(gmopsDevTermRefreshRequest.getDevTermId());
            }
            if(gmDevTerm != null) {
                gmopsDevTerm = new GmopsDevTermDo();
                gmopsDevTerm.setId(idGenerator.nextId());
                gmopsDevTerm.setDevTermId(gmDevTerm.getId());
                gmopsDevTerm.setGmtConnectedAt(gmopsDevTermRefreshRequest.getGmtConnectedAt() != null ? gmopsDevTermRefreshRequest.getGmtConnectedAt() : 0L);
                gmopsDevTerm.setGmtHeartbeatUp(gmopsDevTermRefreshRequest.getGmtHeartbeatUp() != null ? gmopsDevTermRefreshRequest.getGmtHeartbeatUp() : 0L);
                gmopsDevTerm.setGmtMessageUp(gmopsDevTermRefreshRequest.getGmtMessageUp() != null ? gmopsDevTermRefreshRequest.getGmtMessageUp() : 0L);
                gmopsDevTerm.setGmtMeasdataUp(gmopsDevTermRefreshRequest.getGmtMeasdataUp() != null ? gmopsDevTermRefreshRequest.getGmtMeasdataUp() : 0L);
                gmopsDevTerm.setGmtAlarmUp(gmopsDevTermRefreshRequest.getGmtAlarmUp() != null ? gmopsDevTermRefreshRequest.getGmtAlarmUp() : 0L);
                gmopsDevTerm.setValid(true);
                gmopsDevTerm.setCreator("IESMS_BP");
                gmopsDevTerm.setGmtCreate(System.currentTimeMillis());
                gmopsDevTerm.setModifier("IESMS_BP");
                gmopsDevTerm.setGmtModified(System.currentTimeMillis());
                gmopsDevTerm.setInvalider("");
                gmopsDevTerm.setGmtInvalid(0L);
                gmopsDevTerm.setVersion(1);
                gmopsDevTermDao.insert(gmopsDevTerm);
            }
        }
        else {
            if(gmopsDevTermRefreshRequest.getGmtConnectedAt() != null) {
                gmopsDevTerm.setGmtConnectedAt(gmopsDevTermRefreshRequest.getGmtConnectedAt());
            }
            if(gmopsDevTermRefreshRequest.getGmtHeartbeatUp() != null) {
                gmopsDevTerm.setGmtHeartbeatUp(gmopsDevTermRefreshRequest.getGmtHeartbeatUp());
            }
            if(gmopsDevTermRefreshRequest.getGmtMessageUp() != null) {
                gmopsDevTerm.setGmtMessageUp(gmopsDevTermRefreshRequest.getGmtMessageUp());
            }
            if(gmopsDevTermRefreshRequest.getGmtMeasdataUp() != null) {
                gmopsDevTerm.setGmtMeasdataUp(gmopsDevTermRefreshRequest.getGmtMeasdataUp());
            }
            if(gmopsDevTermRefreshRequest.getGmtAlarmUp() != null) {
                gmopsDevTerm.setGmtAlarmUp(gmopsDevTermRefreshRequest.getGmtAlarmUp());
            }
            gmopsDevTerm.setModifier("IESMS_BP");
            gmopsDevTerm.setGmtModified(System.currentTimeMillis());
            gmopsDevTermDao.update(gmopsDevTerm);
        }
        gmopsDevTermRefreshResponse.setSuccess();
        gmopsDevTermRefreshResponse.setGmopsDevTerm(gmopsDevTerm);

        if(logger.isDebugEnabled()) {
            logger.debug(" GmopsDevTermRefreshResponse  : " + JsonConvertUtils.convertToString(gmopsDevTermRefreshResponse));
            logger.debug(" <<<<<<< end refreshGmopsDevTerm <<<<<<< ");
        }
        return gmopsDevTermRefreshResponse;
    }

}
