package com.iesms.bizprocessors.idcc.entity;

import cn.hutool.core.date.DateUtil;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 报文解析实体类
 * @author Lin yicheng
 * @date 2022/12/7 16:44
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Builder
public class IdccMessageAnalysis implements Serializable {

    private static final long serialVersionUID = 9109341630581531891L;

    /**
     * 资产设备编码（必填）
     */
    private String assetCode;

    /**
     * 资产模型编码（必填）
     */
    private String assetTypeCode;

    /**
     * 资产属性编码（必填）
     */
    private String attributeCode;

    /**
     * 质量码（⾮必填）
     */
    private Long quality;

    /**
     * 时间戳,unix毫秒（⾮必填）
     */
    private Long timestamp;

    /**
     * 属性数值（必填）
     */
    private Object value;

}
