package com.iesms.bizprocessors.jalasmartgateway.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 *
 * @see GatewayDeviceMqttJsonDto
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayDeviceLineMqttJsonDto implements Serializable {

    private static final long serialVersionUID = -6025913312873702894L;

    @JsonProperty("LINEID")
    private String lineId;

    @JsonProperty("LINENO")
    private Integer lineNo;

    @JsonProperty("MODEL")
    private String model;

    @JsonProperty("ISLEAKAGE")
    private Integer isLeakage;

    /**
     * 是否禁用物理开关
     * 见文档《上海佳岚智能网关应用端MQTT接入说明》 4.9 禁用物理开关
     *      1表示禁用物理开关，0表示启用物理开关。
     * 为了和字面意义一致改成disableSwitch
     * 同理，表jala_smart_switch_line中is_disable_switch字段
     */
    @JsonProperty("ENABLE_SWITCH")
    private Integer disableSwitch;

}
