package com.iesms.bizprocessors.jalasmartgateway.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @see GatewayPower3MqttJsonDto
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayPower3LineMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 2167634178760242046L;

    /**
     * 线路编号
     */
    @JsonProperty("LINENO")
    private Integer lineNo;

    /**
     *
     */
    @JsonProperty("CURRENTA")
    private BigDecimal currentA;

    /**
     *
     */
    @JsonProperty("CURRENTB")
    private BigDecimal currentB;

    /**
     *
     */
    @JsonProperty("CURRENTC")
    private BigDecimal currentC;

    /**
     *
     */
    @JsonProperty("VOLTAGEAB")
    private BigDecimal voltageAb;

    /**
     *
     */
    @JsonProperty("VOLTAGEBC")
    private BigDecimal voltageBc;

    /**
     *
     */
    @JsonProperty("VOLTAGECA")
    private BigDecimal voltageCa;

    /**
     *
     */
    @JsonProperty("LEAKAGE")
    private BigDecimal leakage;

    /**
     *
     */
    @JsonProperty("P_A")
    private BigDecimal powerA;

    /**
     *
     */
    @JsonProperty("P_B")
    private BigDecimal powerB;

    /**
     *
     */
    @JsonProperty("P_C")
    private BigDecimal powerC;

    /**
     *
     */
    @JsonProperty("POWER")
    private BigDecimal power;

}
