package com.iesms.bizprocessors.jalasmartgateway.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @see GatewayParameterMqttJsonDto
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayParameterLineMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 7247153133148671822L;

    @JsonProperty("LINENO")
    private Integer lineNo;

    @JsonProperty("UNDER")
    private BigDecimal under;

    @JsonProperty("OVER")
    private BigDecimal over;

    @JsonProperty("MAX")
    private BigDecimal max;

    @JsonProperty("LEAKVALUE")
    private BigDecimal leakValue;

    @JsonProperty("ERR_LEAKVALUE")
    private BigDecimal errLeakValue;

}
