package com.iesms.bizprocessors.jalasmartgateway.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * 订阅主题：
 * /ProductKey/ClientName/power3
 * 数据格式：
 * {
 *     "TimeStamp": 1491355918,
 *     "Lines": [
 *         {
 *              "LineNo":1,
 *              "CurrentA":3.21,
 *              "CurrentB":4.35,
 *              "CurrentC":6.08,
 *              "VoltageAB":121,
 *              "VoltageBC":122,
 *              "VoltageCA":123,
 *              "Leakage":"12",
 *              "P_A":470,
 *              "P_B":470,
 *              "P_C":470,
 *              "Power":470
 *         }
 *     ]
 * }
 *
 * 属性说明：
 * 序号	属性	说明
 * 1	TimeStamp	时间戳
 * 2	Lines	线路集合。LineNo表示线路编号，Voltage表示线路电压，Current表示电流，Power表示功率
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayPower3MqttJsonDto implements Serializable {

    private static final long serialVersionUID = 1631550561900093518L;

    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    @JsonProperty("LINES")
    private List<GatewayPower3LineMqttJsonDto> lines;

}
