package com.iesms.bizprocessors.jalasmartgateway.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @see GatewayTemp3MqttJsonDto
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayTemp3LineMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 6952106767377011548L;

    /**
     * 线路编号
     */
    @JsonProperty("LINENO")
    private Integer lineNo;

    /**
     *
     */
    @JsonProperty("TEMPA")
    private BigDecimal tempA;

    /**
     *
     */
    @JsonProperty("TEMPB")
    private BigDecimal tempB;

    /**
     *
     */
    @JsonProperty("TEMPC")
    private BigDecimal tempC;

    /**
     *
     */
    @JsonProperty("TEMPN")
    private BigDecimal tempN;

}
