package com.iesms.bizprocessors.jalasmartgateway.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * 订阅主题：
 * /ProductKey/ClientName/leakage
 * 数据格式：
 * {
 *     "TimeStamp": 1491355918,
 *     "Lines": [
 *         {
 *             "LineNo": 1,
 *             "Current": 0.79
 *         },
 *         {
 *             "LineNo": 2,
 *             "Current": 1.12
 *         }
 *     ]
 * }
 * 属性说明：
 * 序号	属性	说明
 * 1	TimeStamp	时间戳
 * 2	Lines	线路集合。LineNo表示线路编号，Current表示漏电值
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayLeakageMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 6419214260413483740L;

    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    @JsonProperty("LINES")
    private List<GatewayLeakageLineMqttJsonDto> lines;

}
