package com.iesms.bizprocessors.jalasmartgateway.response;

import com.iesms.bizprocessors.jalasmartgateway.constant.ReturnResponseResultEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-11
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ReturnResponse implements Serializable {

    private static final long serialVersionUID = 821279589359372214L;

    /**
     * 返回状态码：SUCCESS - 成功；FAILURE - 失败；
     */
    private String returnCode;

    /**
     * 返回信息：当返回状态码为FAILURE时返回信息为错误原因
     */
    private String returnMsg;

    public void setReturnResponseResult(ReturnResponseResultEnum returnResponseResult) {
        this.returnCode = returnResponseResult.getReturnCode();
        this.returnMsg = returnResponseResult.getReturnMsg();
    }

    public boolean isSuccess() {
        return "SUCCESS".equals(this.returnCode);
    }

}