package com.iesms.bizprocessors.jalasmartgateway.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 漏电测试
 *
 * 订阅主题：
 * /ProductKey/ClientName/isLeakagetest
 * 数据格式：
 * {
 *     "Code": " TEST",
 *     "TimeStamp": 1491356290,
 *     "LineNo": 1,
 *     "Content": "true",
 *     "Data": 0.12
 * }
 *
 * 属性说明：
 * 序号	属性	说明
 * 1	Code	功能类型
 * 2	TimeStamp	测试完成时的时间戳
 * 3	LineNo	测试的线路编号
 * 4	Content	测试结果，true为正常 false为异常
 * 5	Data	漏电值
 *
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayIsLeakagetestMqttJsonDto implements Serializable {

    private static final long serialVersionUID = 4430539776895335725L;

    /**
     * 时间戳
     */
    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    /**
     * 线路编号
     */
    @JsonProperty("LINENO")
    private Integer lineNo;

    /**
     * 功能类型
     */
    @JsonProperty("CODE")
    private String code;

    /**
     * 测试结果
     */
    @JsonProperty("CONTENT")
    private String content;

    /**
     * 漏电值
     */
    @JsonProperty("DATA")
    private BigDecimal data;

}
