package com.iesms.bizprocessors.jalasmartgateway.jsondto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 *
 * 订阅主题：
 * /ProductKey/ClientName/power
 * 数据格式：
 * {
 *     "TimeStamp": 1491355918,
 *     "Lines": [
 *         {
 *             "LineNo": 1,
 *             "Voltage": 213,
 *             "Current": 2.21,
 *             "Power": 470
 *         },
 *         {
 *             "LineNo": 2,
 *             "Voltage": 213,
 *             "Current": 3.53,
 *             "Power": 752
 *         }
 *     ]
 * }
 *
 * 属性说明：
 * 序号	属性	说明
 * 1	TimeStamp	时间戳
 * 2	Lines	线路集合。LineNo表示线路编号，Voltage表示线路电压，Current表示电流，Power表示功率
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect
public class GatewayPowerMqttJsonDto implements Serializable {

    private static final long serialVersionUID = -8515697785752204368L;

    @JsonProperty("TIMESTAMP")
    private Long timeStamp;

    @JsonProperty("LINES")
    private List<GatewayPowerLineMqttJsonDto> lines;

}
