package com.iesms.bizprocessors.jalasmartgateway.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.jalasmartgateway.constant.ReturnResponseResultEnum;
import com.iesms.bizprocessors.jalasmartgateway.dao.JalaMqttSubscriptionsDao;
import com.iesms.bizprocessors.jalasmartgateway.entity.JalaMqttSubscriptionsDo;
import com.iesms.bizprocessors.jalasmartgateway.request.JalaMqttSubscriptionsGetRequest;
import com.iesms.bizprocessors.jalasmartgateway.request.JalaMqttSubscriptionsRefreshRequest;
import com.iesms.bizprocessors.jalasmartgateway.response.JalaMqttSubscriptionsGetResponse;
import com.iesms.bizprocessors.jalasmartgateway.response.ReturnResponse;
import com.iesms.bizprocessors.jalasmartgateway.service.JalaMqttSubscriptionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-05
 */
@Service
public class JalaMqttSubscriptionsServiceImpl extends AbstractBaseService implements JalaMqttSubscriptionsService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JalaMqttSubscriptionsDao jalaMqttSubscriptionsDao;

    @Autowired
    public JalaMqttSubscriptionsServiceImpl(JalaMqttSubscriptionsDao jalaMqttSubscriptionsDao) {
        this.jalaMqttSubscriptionsDao = jalaMqttSubscriptionsDao;
    }

    @Override
    public ReturnResponse refreshJalaMqttSubscriptions(JalaMqttSubscriptionsRefreshRequest refreshRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start refreshJalaMqttSubscriptions >>>>>> ");
            logger.debug(" JalaMqttSubscriptionsRefreshRequest  : " + JsonConvertUtils.convertToString(refreshRequest));
        }
        ReturnResponse returnResponse = new ReturnResponse();
        returnResponse.setReturnResponseResult(ReturnResponseResultEnum.FAILURE);
        if(refreshRequest != null && !StringUtils.isAnyBlank(refreshRequest.getClientId(), refreshRequest.getTopic())) {
            JalaMqttSubscriptionsDo jalaMqttSubscriptionsDo = jalaMqttSubscriptionsDao.getByClientIdAndTopic(refreshRequest.getClientId(), refreshRequest.getTopic());
            if(jalaMqttSubscriptionsDo != null) {
                /// update
                jalaMqttSubscriptionsDo.setGmtModified(System.currentTimeMillis());
                jalaMqttSubscriptionsDao.updateByClientIdAndTopic(jalaMqttSubscriptionsDo);
            }
            else {
                /// insert
                jalaMqttSubscriptionsDo = new JalaMqttSubscriptionsDo(idGenerator.nextId(),
                        refreshRequest.getClientId(),
                        refreshRequest.getNode(),
                        refreshRequest.getQos(),
                        refreshRequest.getTopic(),
                        refreshRequest.getProductKey(),
                        refreshRequest.getUpcommLogicAddr(),
                        System.currentTimeMillis(),
                        System.currentTimeMillis(),
                        1
                );
                jalaMqttSubscriptionsDao.insert(jalaMqttSubscriptionsDo);
            }
            returnResponse.setReturnResponseResult(ReturnResponseResultEnum.SUCCESS);
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end refreshJalaMqttSubscriptions <<<<<<< ");
        }
        return returnResponse;
    }

    @Override
    public JalaMqttSubscriptionsGetResponse getJalaMqttSubscriptions(JalaMqttSubscriptionsGetRequest getRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getJalaMqttSubscriptions >>>>>> ");
            logger.debug(" JalaMqttSubscriptionsGetRequest  : " + JsonConvertUtils.convertToString(getRequest));
        }
        JalaMqttSubscriptionsGetResponse getResponse = new JalaMqttSubscriptionsGetResponse();
        getResponse.setReturnResponseResult(ReturnResponseResultEnum.FAILURE);
        if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getUpcommLogicAddr())) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("productKey", getRequest.getProductKey());
            params.put("upcommLogicAddr", getRequest.getUpcommLogicAddr());
            List<JalaMqttSubscriptionsDo> jalaMqttSubscriptionsDoList = jalaMqttSubscriptionsDao.getList(params, null, null);
            if(logger.isDebugEnabled()) {
                logger.debug(" jalaMqttSubscriptionsDoList : " + JsonConvertUtils.convertToString(jalaMqttSubscriptionsDoList));
            }
            if(jalaMqttSubscriptionsDoList != null && jalaMqttSubscriptionsDoList.size() > 0) {
                JalaMqttSubscriptionsDo jalaMqttSubscriptionsDo = jalaMqttSubscriptionsDoList.get(0);
                if(logger.isDebugEnabled()) {
                    logger.debug(" jalaMqttSubscriptionsDo : " + JsonConvertUtils.convertToString(jalaMqttSubscriptionsDo));
                }
                getResponse.setReturnResponseResult(ReturnResponseResultEnum.SUCCESS);
                getResponse.setJalaMqttSubscriptionsDo(jalaMqttSubscriptionsDo);
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end getJalaMqttSubscriptions <<<<<<< ");
        }
        return getResponse;
    }
}
