package com.iesms.bizprocessors.jalasmartgateway.service.impl;

import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.bizprocessors.jalasmartgateway.constant.ReturnResponseResultEnum;
import com.iesms.bizprocessors.jalasmartgateway.dao.JalaMqttmsgPublishLogDao;
import com.iesms.bizprocessors.jalasmartgateway.dao.JalaMqttmsgReceivedLogDao;
import com.iesms.bizprocessors.jalasmartgateway.entity.JalaMqttmsgPublishLogDo;
import com.iesms.bizprocessors.jalasmartgateway.entity.JalaMqttmsgReceivedLogDo;
import com.iesms.bizprocessors.jalasmartgateway.request.JalaMqttmsgPublishLogInsertRequest;
import com.iesms.bizprocessors.jalasmartgateway.request.JalaMqttmsgReceivedLogInsertRequest;
import com.iesms.bizprocessors.jalasmartgateway.response.ReturnResponse;
import com.iesms.bizprocessors.jalasmartgateway.service.JalaMqttmsgLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-13
 */
@Service
public class JalaMqttmsgLogServiceImpl extends AbstractBaseService implements JalaMqttmsgLogService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JalaMqttmsgReceivedLogDao jalaMqttmsgReceivedLogDao;

    private final JalaMqttmsgPublishLogDao jalaMqttmsgPublishLogDao;

    @Autowired
    public JalaMqttmsgLogServiceImpl(JalaMqttmsgReceivedLogDao jalaMqttmsgReceivedLogDao, JalaMqttmsgPublishLogDao jalaMqttmsgPublishLogDao) {
        this.jalaMqttmsgReceivedLogDao = jalaMqttmsgReceivedLogDao;
        this.jalaMqttmsgPublishLogDao = jalaMqttmsgPublishLogDao;
    }

    @Override
    public ReturnResponse insertJalaMqttmsgReceivedLog(JalaMqttmsgReceivedLogInsertRequest insertRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start insertJalaMqttmsgReceivedLog >>>>>> ");
            logger.debug(" JalaMqttmsgReceivedLogInsertRequest  : " + JsonConvertUtils.convertToString(insertRequest));
        }
        ReturnResponse returnResponse = new ReturnResponse();
        returnResponse.setReturnResponseResult(ReturnResponseResultEnum.FAILURE);
        if(insertRequest != null) {
            JalaMqttmsgReceivedLogDo receivedLog = new JalaMqttmsgReceivedLogDo(
                    idGenerator.nextId(),
                    insertRequest.getPayload(),
                    insertRequest.getTopic(),
                    insertRequest.getQos(),
                    insertRequest.isRetained(),
                    insertRequest.isDuplicate(),
                    insertRequest.getReceivedProductKey(),
                    insertRequest.getReceivedClientId(),
                    insertRequest.getReceivedMessageId(),
                    ObjectUtils.defaultIfNull(insertRequest.getReceivedMessageTimestamp(), System.currentTimeMillis())
            );
            int result = jalaMqttmsgReceivedLogDao.insertLog(receivedLog);
            if(result > 0) {
                returnResponse.setReturnResponseResult(ReturnResponseResultEnum.SUCCESS);
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" ReturnResponse  : " + JsonConvertUtils.convertToString(returnResponse));
            logger.debug(" <<<<<<< end insertJalaMqttmsgReceivedLog <<<<<<< ");
        }
        return returnResponse;
    }

    @Override
    public ReturnResponse insertJalaMqttmsgPublishLog(JalaMqttmsgPublishLogInsertRequest insertRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start insertJalaMqttmsgPublishLog >>>>>> ");
            logger.debug(" JalaMqttmsgPublishLogInsertRequest  : " + JsonConvertUtils.convertToString(insertRequest));
        }
        ReturnResponse returnResponse = new ReturnResponse();
        returnResponse.setReturnResponseResult(ReturnResponseResultEnum.FAILURE);
        if(insertRequest != null) {
            JalaMqttmsgPublishLogDo publishLog = new JalaMqttmsgPublishLogDo(
                    idGenerator.nextId(),
                    insertRequest.getPayload(),
                    insertRequest.getTopic(),
                    insertRequest.getQos(),
                    insertRequest.isRetained(),
                    insertRequest.isDuplicate(),
                    insertRequest.getPublishProductKey(),
                    insertRequest.getPublishClientId(),
                    System.currentTimeMillis()
            );
            int result = jalaMqttmsgPublishLogDao.insertLog(publishLog);
            if(result > 0) {
                returnResponse.setReturnResponseResult(ReturnResponseResultEnum.SUCCESS);
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" ReturnResponse  : " + JsonConvertUtils.convertToString(returnResponse));
            logger.debug(" <<<<<<< end insertJalaMqttmsgPublishLog <<<<<<< ");
        }
        return returnResponse;
    }

}
