package com.iesms.bizprocessors.jalasmartgateway.service.impl;


import com.iesms.bizprocessors.jalasmartgateway.constant.ReturnResponseResultEnum;
import com.iesms.bizprocessors.jalasmartgateway.dao.JalaSoeMessageDao;
import com.iesms.bizprocessors.jalasmartgateway.entity.JalaSoeMessageDo;
import com.iesms.bizprocessors.jalasmartgateway.request.JalaSoeMessageInsertRequest;
import com.iesms.bizprocessors.jalasmartgateway.response.ReturnResponse;
import com.iesms.bizprocessors.jalasmartgateway.service.JalaSoeMessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: lifeng.du
 * @email: xxx@xx.com
 * @date: 2023/6/15 9:54
 */
@Service
public class JalaSoeMessageServiceImpl extends AbstractBaseService implements JalaSoeMessageService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final JalaSoeMessageDao jalaSoeMessageDao;

    public JalaSoeMessageServiceImpl(JalaSoeMessageDao jalaSoeMessageDao) {
        this.jalaSoeMessageDao = jalaSoeMessageDao;
    }

    @Override
    public ReturnResponse insertJalaSoeMessage(JalaSoeMessageInsertRequest insertRequest) {

        ReturnResponse returnResponse = new ReturnResponse();
        returnResponse.setReturnResponseResult(ReturnResponseResultEnum.FAILURE);
        if(insertRequest != null) {
            JalaSoeMessageDo receivedLog = new JalaSoeMessageDo(
                    idGenerator.nextId(),
                    insertRequest.getClientId(),
                    insertRequest.getLineNo(),
                    insertRequest.getSoeCode(),
                    insertRequest.getContent(),
                    insertRequest.getData(),
                    insertRequest.getGmtSoeMessage(),
                    insertRequest.getGmtCreate()
            );
            int result = jalaSoeMessageDao.insertLog(receivedLog);
            if(result > 0) {
                returnResponse.setReturnResponseResult(ReturnResponseResultEnum.SUCCESS);
            }
        }
        return returnResponse;
    }
}
