package com.iesms.bizprocessors.jinhua104.service.impl;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.iesms.bizprocessors.entity.Huayun104MqmsgReceivedLog;
import com.iesms.bizprocessors.jinhua104.dao.Jinhua104Mapper;
import com.iesms.bizprocessors.service.Jinhua104Service;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author Lin yicheng
 * @date 2022/7/22 14:07
 */
@Service
public class Jinhua104ServiceImpl implements Jinhua104Service {

    @Resource
    private Jinhua104Mapper jinhua104Mapper;

    @Override
    public void insertMqmsgReceivedLog(Huayun104MqmsgReceivedLog receivedLog) {
        if (ObjectUtil.isNotEmpty(receivedLog)) {
            jinhua104Mapper.insert(receivedLog);
        }
    }

    @Override
    public void deletePayload() {
        long millisecond = NumberUtil.parseLong(String.valueOf(NumberUtil.sub(NumberUtil.toBigDecimal(System.currentTimeMillis()),NumberUtil.mul(3,24,60,60,1000))));
        LambdaQueryWrapper<Huayun104MqmsgReceivedLog> query = Wrappers.<Huayun104MqmsgReceivedLog>lambdaQuery()
                .le(Huayun104MqmsgReceivedLog::getGmtCreate,millisecond);
        jinhua104Mapper.delete(query);
    }
}
