/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.bizprocessors.mqttgateway.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.mqttgateway.constant.MqttResponseResultEnum;
import com.iesms.bizprocessors.mqttgateway.dao.JalaMqttSubscriptionsDao;
import com.iesms.bizprocessors.mqttgateway.entity.JalaMqttSubscriptionsDo;
import com.iesms.bizprocessors.mqttgateway.request.JalaMqttSubscriptionsGetRequest;
import com.iesms.bizprocessors.mqttgateway.request.JalaMqttSubscriptionsRefreshRequest;
import com.iesms.bizprocessors.mqttgateway.response.JalaMqttSubscriptionsGetResponse;
import com.iesms.bizprocessors.mqttgateway.response.MqttReturnResponse;
import com.iesms.bizprocessors.mqttgateway.service.JalaMqttSubscriptionsService;
import com.iesms.bizprocessors.mqttgateway.service.impl.AbstractBaseService;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JalaMqttSubscriptionsServiceImpl
extends AbstractBaseService
implements JalaMqttSubscriptionsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JalaMqttSubscriptionsDao jalaMqttSubscriptionsDao;

    @Autowired
    public JalaMqttSubscriptionsServiceImpl(JalaMqttSubscriptionsDao jalaMqttSubscriptionsDao) {
        this.jalaMqttSubscriptionsDao = jalaMqttSubscriptionsDao;
    }

    public MqttReturnResponse refreshJalaMqttSubscriptions(JalaMqttSubscriptionsRefreshRequest refreshRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start refreshJalaMqttSubscriptions >>>>>> ");
            this.logger.debug(" JalaMqttSubscriptionsRefreshRequest  : " + JsonConvertUtils.convertToString((Object)refreshRequest));
        }
        MqttReturnResponse returnResponse = new MqttReturnResponse();
        returnResponse.setReturnResponseResult(MqttResponseResultEnum.FAILURE);
        if (refreshRequest != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{refreshRequest.getClientId(), refreshRequest.getTopic()})) {
            JalaMqttSubscriptionsDo jalaMqttSubscriptionsDo = this.jalaMqttSubscriptionsDao.getByClientIdAndTopic(refreshRequest.getClientId(), refreshRequest.getTopic());
            if (jalaMqttSubscriptionsDo != null) {
                jalaMqttSubscriptionsDo.setGmtModified(System.currentTimeMillis());
                this.jalaMqttSubscriptionsDao.updateByClientIdAndTopic(jalaMqttSubscriptionsDo);
            } else {
                jalaMqttSubscriptionsDo = new JalaMqttSubscriptionsDo(Long.valueOf(this.idGenerator.nextId()), refreshRequest.getClientId(), refreshRequest.getNode(), refreshRequest.getQos(), refreshRequest.getTopic(), refreshRequest.getProductKey(), refreshRequest.getUpcommLogicAddr(), System.currentTimeMillis(), System.currentTimeMillis(), 1);
                this.jalaMqttSubscriptionsDao.insert(jalaMqttSubscriptionsDo);
            }
            returnResponse.setReturnResponseResult(MqttResponseResultEnum.SUCCESS);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end refreshJalaMqttSubscriptions <<<<<<< ");
        }
        return returnResponse;
    }

    public JalaMqttSubscriptionsGetResponse getJalaMqttSubscriptions(JalaMqttSubscriptionsGetRequest getRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start getJalaMqttSubscriptions >>>>>> ");
            this.logger.debug(" JalaMqttSubscriptionsGetRequest  : " + JsonConvertUtils.convertToString((Object)getRequest));
        }
        JalaMqttSubscriptionsGetResponse getResponse = new JalaMqttSubscriptionsGetResponse();
        getResponse.setReturnResponseResult(MqttResponseResultEnum.FAILURE);
        if (getRequest != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{getRequest.getProductKey(), getRequest.getUpcommLogicAddr()})) {
            HashMap params = Maps.newHashMap();
            params.put("productKey", getRequest.getProductKey());
            params.put("upcommLogicAddr", getRequest.getUpcommLogicAddr());
            List jalaMqttSubscriptionsDoList = this.jalaMqttSubscriptionsDao.getList(params, null, null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" jalaMqttSubscriptionsDoList : " + JsonConvertUtils.convertToString((Object)jalaMqttSubscriptionsDoList));
            }
            if (jalaMqttSubscriptionsDoList != null && jalaMqttSubscriptionsDoList.size() > 0) {
                JalaMqttSubscriptionsDo jalaMqttSubscriptionsDo = (JalaMqttSubscriptionsDo)jalaMqttSubscriptionsDoList.get(0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" jalaMqttSubscriptionsDo : " + JsonConvertUtils.convertToString((Object)jalaMqttSubscriptionsDo));
                }
                getResponse.setReturnResponseResult(MqttResponseResultEnum.SUCCESS);
                getResponse.setJalaMqttSubscriptionsDo(jalaMqttSubscriptionsDo);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end getJalaMqttSubscriptions <<<<<<< ");
        }
        return getResponse;
    }
}

