/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.bizprocessors.mqttgateway.service.impl;

import cn.hutool.core.lang.generator.SnowflakeGenerator;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.bizprocessors.common.dao.SoeRecordOnOffAlarmDao;
import com.iesms.bizprocessors.common.entity.AlarmVo;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import com.iesms.bizprocessors.mqttgateway.dao.MqttmsgMapper;
import com.iesms.bizprocessors.mqttgateway.entity.CeDevice;
import com.iesms.bizprocessors.mqttgateway.service.SoeRecordAlarmService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SoeRecordAlarmServiceImpl
implements SoeRecordAlarmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoeRecordAlarmServiceImpl.class);
    private static final SnowflakeGenerator SNOWFLAKE_GENERATOR = new SnowflakeGenerator();
    @Resource
    private MqttmsgMapper mqttmsgMapper;
    @Resource
    private SoeRecordOnOffAlarmDao soeRecordOnOffAlarmDao;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public void UpdateSoeRecordOnOffAlarm(SoeRecordOnOffAlarmDo onOffAlarmDo) {
        HashMap<String, String> map;
        String devMeterCommAddr = onOffAlarmDo.getDevMeterCommAddr();
        String devTermCommAddr = onOffAlarmDo.getDevTermCommAddr();
        Long measPointId = onOffAlarmDo.getMeasPointId();
        String soeSortNo = onOffAlarmDo.getSoeSortNo();
        String soeTitle = onOffAlarmDo.getSoeTitle();
        SoeRecordOnOffAlarmDo devMeterInfo = null;
        if (StrUtil.isNotEmpty((CharSequence)devMeterCommAddr)) {
            map = new HashMap<String, String>();
            map.put("devMeterCommAddr", devMeterCommAddr);
            map.put("devTermCommAddr", devTermCommAddr);
            devMeterInfo = this.soeRecordOnOffAlarmDao.getDevMeterInfo(map);
        } else {
            map = new HashMap();
            map.put("devMeterCommAddr", devMeterCommAddr);
            map.put("measPointId", measPointId.toString());
            devMeterInfo = this.soeRecordOnOffAlarmDao.getDevMeterInfoByMeasePointId(map);
        }
        if (ObjectUtil.isEmpty((Object)devMeterInfo)) {
            return;
        }
        String orgNo = devMeterInfo.getOrgNo();
        Long devMeterId = devMeterInfo.getId();
        String devMeterName = devMeterInfo.getDevMeterName();
        List<CeDevice> ceDeviceList = this.mqttmsgMapper.getCeDeviceInfo(devMeterId);
        String alarmInfo = null;
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (ObjectUtil.isNotEmpty(ceDeviceList)) {
            CeDevice ceDevice = ceDeviceList.get(0);
            onOffAlarmDo.setSoeObjectType(20);
            onOffAlarmDo.setSoeObjectId(ceDevice.getCeDeviceId());
            onOffAlarmDo.setSoeObjectName(ceDevice.getCeDeviceName());
            objectMap.put("soeObjectId", ceDevice.getCeDeviceId());
            alarmInfo = ">>>>>>>>>>>>\u8bbe\u5907\u7f16\u53f7:" + ceDevice.getCeDeviceId() + "--\u8bbe\u5907\u540d\u79f0:" + ceDevice.getCeDeviceName() + "--\u544a\u8b66\u7c7b\u578b:" + soeTitle;
        } else {
            onOffAlarmDo.setSoeObjectType(3);
            onOffAlarmDo.setSoeObjectId(devMeterId);
            onOffAlarmDo.setSoeObjectName(devMeterName);
            objectMap.put("soeObjectId", devMeterId);
            alarmInfo = ">>>>>>>>>>>>\u8868\u8ba1\u7f16\u53f7:" + devMeterId + "--\u8868\u8ba1\u540d\u79f0:" + devMeterName + "--\u544a\u8b66\u7c7b\u578b:" + soeTitle;
        }
        objectMap.put("recovery", false);
        objectMap.put("soeSortNo", soeSortNo);
        SoeRecordOnOffAlarmDo beforeOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(objectMap);
        Boolean onOff = onOffAlarmDo.getOnOff();
        onOffAlarmDo.setOrgNo(orgNo);
        onOffAlarmDo.setSoeSortNo(soeSortNo);
        onOffAlarmDo.setSoeGenTime(new Date());
        HashMap<String, String> stringMap = new HashMap<String, String>();
        stringMap.put("soeGenvalue", "1");
        String soeGenValue = JsonConvertUtils.convertToString(stringMap);
        onOffAlarmDo.setSoeGenValue(soeGenValue);
        if (onOff.booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(alarmInfo);
            }
            if (ObjectUtil.isNotEmpty((Object)beforeOffAlarmDo)) {
                return;
            }
            onOffAlarmDo.setRecovery(false);
            this.insertSoeRecordOnOffAlarm(onOffAlarmDo);
        } else if (ObjectUtil.isNotEmpty((Object)beforeOffAlarmDo)) {
            beforeOffAlarmDo.setRecovery(true);
            beforeOffAlarmDo.setSoeRecTime(new Date());
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("soeRecValue", "0");
            String soeRecValue = JsonConvertUtils.convertToString(map2);
            beforeOffAlarmDo.setSoeRecValue(soeRecValue);
            beforeOffAlarmDo.setGmtModified(System.currentTimeMillis());
            this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(beforeOffAlarmDo);
        } else {
            return;
        }
    }

    public void insertSoeRecordOnOffAlarm(SoeRecordOnOffAlarmDo onOffAlarmDo) {
        onOffAlarmDo.setId(SNOWFLAKE_GENERATOR.next());
        onOffAlarmDo.setSoeLevel(3);
        onOffAlarmDo.setSendSms(false);
        onOffAlarmDo.setSendSmsCount(0);
        onOffAlarmDo.setSortSn(1);
        onOffAlarmDo.setValid(true);
        onOffAlarmDo.setGmtCreate(System.currentTimeMillis());
        onOffAlarmDo.setGmtModified(System.currentTimeMillis());
        onOffAlarmDo.setCreator("alarmSystem");
        onOffAlarmDo.setInvalider("alarmSystem");
        onOffAlarmDo.setModifier("alarmSystem");
        onOffAlarmDo.setGmtInvalid(0L);
        onOffAlarmDo.setVersion(0);
        this.soeRecordOnOffAlarmDao.insertSoeRecordOnOffAlarmDo(onOffAlarmDo);
        long time2 = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" ===================================\u544a\u8b66\u63a8\u9001\u5f00\u59cb===================================");
        }
        AlarmVo alarmVo = new AlarmVo();
        alarmVo.setOrgNo(onOffAlarmDo.getOrgNo());
        alarmVo.setDeviceName(onOffAlarmDo.getSoeObjectName());
        alarmVo.setGraveLevel(String.valueOf(onOffAlarmDo.getGraveLevel()));
        alarmVo.setSoeSortNo(onOffAlarmDo.getSoeSortNo());
        alarmVo.setSoeSortName(onOffAlarmDo.getSoeDesc());
        this.stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT", (Object)JSONUtil.toJsonStr((Object)alarmVo));
        long time3 = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u544a\u8b66\u63a8\u9001\u65f6\u95f4\u4e3a\uff1a" + (time3 - time2) / 1000L);
            LOGGER.debug(" ===================================\u544a\u8b66\u63a8\u9001\u7ed3\u675f ==================================");
        }
    }
}

