package com.iesms.bizprocessors.shcleanrobotgateway.dao;
import com.iesms.bizprocessors.shcleanrobotgateway.entity.AlarmDto;
import com.iesms.bizprocessors.shcleanrobotgateway.entity.RobotCurrentData;
import com.iesms.bizprocessors.shcleanrobotgateway.entity.RobotOperatingCondition;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author zhouyi
 * @className ReportMapper
 * @data 2021/10/18 11:56
 * @Description TODO
 **/
@Mapper
public interface ReportDao {
    /***
     * @Description TODO    根据设备id查询记录
     * @author zhouyi
     * @return com.example.cleanrobot.bean.Report
     * @data 2021/10/18
     * @param deciveId
     */
    RobotOperatingCondition getRobotOperatingCondition(@Param("deciveId") Long deciveId);

    /***
     * @Description TODO   插入机器人工况数据
       * @author zhouyi
     * @return int
     * @data 2021/10/19
     * @param condition
     */
    int insertCondition(@Param("condition") RobotOperatingCondition condition);


    int updateCondition(@Param("condition") RobotOperatingCondition condition);


    AlarmDto getOrgNo(@Param("id")Long id);

    /***
     * @Description TODO 插入电流曲线信息
     * @author zhouyi
     * @return int
     * @data 2021/10/26
     * @param currentData
     */
    int insertRobotCurrentData(@Param("currentData") RobotCurrentData currentData);

    /***
     * @Description TODO  查询所有设备的心跳上送时间
     * @author zhouyi
     * @return com.iesms.bizprocessors.shcleanrobotgateway.entity.RobotOperatingCondition
     * @data 2021/11/5
     */
    List<RobotOperatingCondition> getCondition();

    /***
     * @Description TODO  更新网关状态
     * @author zhouyi
     * @return int
     * @data 2021/11/5
     * @param deviceId
     */
    int updateGateWayStatus(@Param("deviceId")Long deviceId,@Param("gatewayStatus")int gatewayStatus);


    /***
     * @Description TODO   更新通讯状态
     * @author zhouyi
     * @data 2022/3/2
     */
    int updateCommunicateStatus(@Param("deviceId")Long deviceId,@Param("communicateStatus")int communicateStatus);

}
