package com.iesms.bizprocessors.timuiotgateway.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author ghl
 * @date 2020-05-21
 * 提姆惠电MQQT
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TimuMqqtLinkDo implements Serializable {

    private static final long serialVersionUID = 1182010524532916154L;

    /**
     * ID
     */
    private Long id;

    /**
     * 请求服务时间
     */
    private Long time;

    /**
     * 年份为后两位1字节表示。比如2017-04-22 13:58:00是170422135800
     */
    private Long dateTime;

    /**
     * 网关MAC ID  如MAC：00ABCDEF0123
     */
    private String macId;

    /**
     * 硬件版本号   如version：000012345678
     */
    private String sn;

    /**
     * 网关型号
     * 1:WIFI 网口网关 + 485
     * 2:2G网关 + 485
     * 3:4G网关 + 485
     * 4:NB网关 + 485
     */
    private String dataModel;

    /**
     * 协议版本号  1-255
     */
    private String version;

}
