package com.iesms.bizprocessors.timuiotgateway.constant;

/**
 *
 * @author ghl
 * @date 2020-05-25
 */
public enum TimuResponseResultEnum {

    /**
     * 成功
     */
    SUCCESS("SUCCESS", "成功"),

    /**
     * 失败
     */
    FAILURE("FAILURE", "失败");

    /**
     * 返回状态码：SUCCESS - 成功；FAILURE - 失败；
     */
    private String returnCode;

    /**
     * 返回信息：当返回状态码为FAILURE时返回信息为错误原因
     */
    private String returnMsg;

    TimuResponseResultEnum(String returnCode, String returnMsg) {
        this.returnCode = returnCode;
        this.returnMsg = returnMsg;
    }

    public String getReturnCode() {
        return returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMsg() {
        return returnMsg;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    @Override
    public String toString() {
        return "ReturnResponseResultEnum{" +
                "returnCode='" + returnCode + '\'' +
                ", returnMsg='" + returnMsg + '\'' +
                '}';
    }

}
