package com.iesms.bizprocessors.timuiotgateway.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author ghl
 * 断路器设备信息
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TimuMqqtCircuitDo implements Serializable {

    private static final long serialVersionUID = -8690610421791323173L;

    /**
     * 网关MAC ID  如MAC：00ABCDEF0123
     */
    private String mac;

    /**
     * 序列号   如SN：000012345678
     */
    private String serialNumber;

    /**
     * 断路器类型  （如：16A 32A 100A 800A）
     */
    private String dataType;

    /**
     * 断路器型号
     */
    private String dataModel;

    /**
     * 断路器状态  01H  ：断开  ：02H  闭合  03H:离线
     */
    private String dataStatu;

    /**
     * 硬件版本号   如version：000012345678
     */
    private String hardwareNumber;

    /**
     * 程序版本
     */
    private String pv;

    /**
     * 设备出厂时间，如：20190305（2019/03/05）
     */
    private String factoryDate;

    /**
     * 当前设备设置的漏电电流
     */
    private String leakage;

    /**
     * 11ST塑壳M型配置参数模式 0-本地 1-远程
     */
    private String pattern;
}
