package com.iesms.bizprocessors.timuiotgateway.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author : ghl
 * @Date: 2020-08-17 15:45
 */
@Data
public class TimuGmopsDevMeter implements Serializable {

    private static final long serialVersionUID = 5515849834702592325L;

    /**
     * 设备工况标识;SnowflakeId
     */
    private Long id;
    /**
     * 量测表计标识
     */
    private Long devMeterId;
    /**
     * 最近一次报文上行时间
     */
    private long gmtMessageUp;
    /**
     * 最近一次量测数据上行时间
     */
    private long gmtMeasdataUp;
    /**
     * 最近一次告警上行时间
     */
    private long gmtAlarmUp;
    /**
     * 最近一次抄表示数上行时间
     */
    private long gmtReadingUp;
    /**
     * 最近一次抄表示数值
     */
    private BigDecimal readingValue;
    /**
     * 最近一次量测表计状态;1 - 打开；0 - 关闭；
     */
    private int meterStateOpen;
    /**
     * 最近一次量测数据集;针对V-SVG，
     * {
     * "gen_watt_state_svg_run": true,    // SVG运行状态 true / false : 运行 / 停机
     * "gen_watt_state_svg_fault": false  // SVG系统故障 true / false : 故障 / 正常
     */
    private String measDataInfoSet;
    /**
     * 是否有效
     */
    private boolean isValid;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified;
    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;
    /**
     * 失效时间;为0表示为空
     */
    private long gmtInvalid;
    /**
     * 版本号;用于乐观锁
     */
    private int version;
}
