package com.iesms.bizprocessors.timuiotgateway.entity;

import lombok.Data;

import java.io.Serializable;

/**
 * @Author : ghl
 * @Date: 2020-11-13 09:05
 */
@Data
public class TimuGmopsDevTermDo implements Serializable {

    private static final long serialVersionUID = 6951602588970685327L;
    /**
     * 设备工况标识;SnowflakeId
     */
    private Long id;
    /**
     * 采集终端标识
     */
    private Long devTermId;
    /**
     * 最近一次在线时间
     */
    private long gmtConnectedAt;
    /**
     * 最近一次心跳通讯时间
     */
    private long gmtHeartbeatUp;
    /**
     * 最近一次报文上行时间
     */
    private long gmtMessageUp;
    /**
     * 最近一次量测数据上行时间
     */
    private long gmtMeasdataUp;
    /**
     * 最近一次告警上行时间
     */
    private long gmtAlarmUp;
    /**
     * 是否有效
     */
    private boolean isValid;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified;
    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;
    /**
     * 失效时间;为0表示为空
     */
    private long gmtInvalid;
    /**
     * 版本号;用于乐观锁
     */
    private int version;
}
