package com.iesms.bizprocessors.timuiotgateway.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author ghl
 * timu数据域实体
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TimuMqttDataItemDo implements Serializable {

    private static final long serialVersionUID = 8645364389958201956L;

    private byte[] dateTime;

    /**
     * 网关MAC ID  如MAC：00ABCDEF0123
     */
    private byte[] macId;

    /**
     * 硬件版本号
     */
    private byte[] sn;

    /**
     * 程序版本
     */
    private byte[] pv;

    /**
     * 网关型号
     * 1:WIFI 网口网关 + 485
     * 2:2G网关 + 485
     * 3:4G网关 + 485
     * 4:NB网关 + 485
     */
    private byte dataModel;

    /**
     * 协议版本
     */
    private byte csv;

    /**
     * 断路器状态  01H  ：断开  ：02H  闭合  03H:离线
     */
    private byte dataStatu;

    /**
     * 设备出厂时间，如：20190305（2019/03/05）
     */
    private int factoryDate;

    /**
     * 11ST塑壳M型配置参数模式 0-本地 1-远程
     */
    private byte Pattern;

    /**
     * 重合次数（0、1、2、3）
     */
    private byte coincidence;

    /**
     * 此位置4个字节（32个位），可用做32个错误表达，全为0代表无异常
     */
    private byte[] errCode;

    /**
     * 电压 单位V
     */
    private Short voltage;

    /**
     * 电流 单位A
     */
    private Short current;

    /**
     * 功率 单位W
     */
    private byte[] power;

    /**
     * 温度 单位度,补码
     */
    private byte temper;

    /**
     * 漏电值 单位mA
     */
    private Short leakage;

    /**
     * 错误类型(01-预警 02-报警)
     */
    private byte type;

    /**
     * 01H  ：断开  02H ：闭合 03H：全断开 04H ：全闭合
     */
    private byte cmd;

    /**
     * 01H  ：断开  ：02H  闭合  03H:失联  04H：失败
     */
    private byte data1Sta;

    /**
     * 断路器类型
     * 01H : 机械动作回复   02H : 获取状态回复
     */
    private byte dataType;
}
