package com.iesms.bizprocessors.timuiotgateway.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author ghl
 * timuMqtt消息实体
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TimuMqttMessageDo implements Serializable {

    private static final long serialVersionUID = 6812624522407820638L;

    private Long id;

    /**
     * 客户端标识
     */
    private String clientId;

    /**
     * MQTT集群节点
     */
    private String node;

    /**
     * 接入网关设备所属产品
     */
    private String productKey;

    /**
     * 上行通讯逻辑地址
     */
    private String upcommLogicAddr;

    /**
     * 数据载体
     */
    private Object payload;

    /**
     * 数据字节
     */
    private byte[] payloadByte;

    /**
     * 主题
     */
    private String topic;

    /**
     * 服务质量等级
     */
    private Integer qos;

    /**
     * Retained 消息
     * retained 消息是指在 PUBLISH 数据包中 Retain 标识设为 1 的消息，Broker 收到这样的 PUBLISH 包以后，
     * 将保存这个消息，当有一个新的订阅者订阅相应主题的时候，Broker 会马上将这个消息发送给订阅者。
     * <p>
     * 注：Retained 消息和持久性会话没有任何关系，Retained 消息是 Broker 为每一个 Topic 单独存储的，
     * 而持久性会话是 Broker 为每一个 Client 单独存储的。
     * <p>
     * LWT
     * LWT 全称为 Last Will and Testament，也就是我们在连接到 Broker 时提到的遗愿，
     * 包括遗愿主题、遗愿 QoS、遗愿消息等。顾名思义，当 Broker 检测到 Client 非正常地断开连接的时候，
     * 就会向遗愿主题里面发布一条消息。遗愿相关的设置是在建立连接的时候，在 CONNECT 数据包里面指定的。
     * <p>
     * Will Flag：是否使用 LWT
     * Will Topic：遗愿主题名，不可使用通配符
     * Will Qos：发布遗愿消息时使用的 QoS
     * Will Retain：遗愿消息的 Retain 标识
     * Will Message：遗愿消息内容
     */
    private Boolean retained;

    /**
     * 重复下发
     */
    private Boolean duplicate;

    /**
     * 接收到的消息头的ID
     */
    private String receivedMessageId;

    /**
     * 消息时间戳
     */
    private Long receivedMessageTimestamp;

    /**
     * 创建时间 为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新时间 为0表示为空
     */
    private Long gmtModified;

    /**
     * 版本号 用于乐观锁
     */
    private int version;

    /**
     * 接收消息产品
     */
    private String receivedProductKey;

    /**
     * 接收消息客户端标识
     */
    private String receivedClientId;

}
