package com.iesms.bizprocessors.timuiotgateway.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author ghl
 * timumqtt接收数据实体
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TimuMqttDataCommonDo implements Serializable {

    private static final long serialVersionUID = 8731397811387095047L;

    /**
     * 开始符
     */
    private byte header;

    /**
     * 长度
     */
    private Short len;

    /**
     * 控制域
     */
    private byte ctrl;

    /**
     * 地址
     */
    private byte[] addr;

    /**
     * 功能码
     */
    private byte type;

    /**
     * 数据域
     */
    private TimuMqttDataItemDo timuMqttDataItemDo;

    /**
     * 数据时效
     */
    private byte[] time;

    /**
     * 校验
     */
    private byte cs;

    /**
     * 终止
     */
    private byte over;
    /**
     * 主题数组
     */
    private String[] topics;

    /**
     * mqttMessage消息实体
     */
    private TimuMqttMessageDo mqttMessageDo;

    /**
     * timuMqtt数据域实体
     */
    private TimuMqttDataItemDo mqttDataItemDo;

}
