package com.iesms.bizprocessors.timuiotgateway.response;

import com.iesms.bizprocessors.timuiotgateway.constant.TimuResponseResultEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author ghl
 * @date 2020-05-25
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TimuReturnResponse implements Serializable {

    private static final long serialVersionUID = 821279589359372214L;

    /**
     * 返回状态码：SUCCESS - 成功；FAILURE - 失败；
     */
    private String returnCode;

    /**
     * 返回信息：当返回状态码为FAILURE时返回信息为错误原因
     */
    private String returnMsg;

    public void setReturnResponseResult(TimuResponseResultEnum responseResult) {
        this.returnCode = responseResult.getReturnCode();
        this.returnMsg = responseResult.getReturnMsg();
    }

    public boolean isSuccess() {
        return "SUCCESS".equals(this.returnCode);
    }

}