/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.bizprocessors.timuiotgateway.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.timuiotgateway.constant.TimuResponseResultEnum;
import com.iesms.bizprocessors.timuiotgateway.dao.TimuMqttSubscriptionsDao;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuMqttSubscriptionsDo;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttSubscriptionsGetRequest;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttSubscriptionsRefreshRequest;
import com.iesms.bizprocessors.timuiotgateway.response.TimuMqttSubscriptionsGetResponse;
import com.iesms.bizprocessors.timuiotgateway.response.TimuReturnResponse;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttSubscriptionsService;
import com.iesms.bizprocessors.timuiotgateway.service.impl.AbstractBaseService;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimuMqttSubscriptionsServiceImpl
extends AbstractBaseService
implements TimuMqttSubscriptionsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TimuMqttSubscriptionsDao timuMqttSubscriptionsDao;

    public TimuReturnResponse refreshTimuMqttSubscriptions(TimuMqttSubscriptionsRefreshRequest refreshRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start refreshTimuMqttSubscriptions >>>>>> ");
            this.logger.debug(" TimuMqttSubscriptionsRefreshRequest  : " + JsonConvertUtils.convertToString((Object)refreshRequest));
        }
        TimuReturnResponse returnResponse = new TimuReturnResponse();
        if (refreshRequest != null && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{refreshRequest.getClientId(), refreshRequest.getTopic()})) {
            TimuMqttSubscriptionsDo timuMqttSubscriptionsDo = this.timuMqttSubscriptionsDao.getByClientIdAndTopic(refreshRequest.getClientId(), refreshRequest.getTopic());
            if (timuMqttSubscriptionsDo != null) {
                timuMqttSubscriptionsDo.setGmtModified(System.currentTimeMillis());
                this.timuMqttSubscriptionsDao.updateByClientIdAndTopic(timuMqttSubscriptionsDo);
            } else {
                timuMqttSubscriptionsDo = new TimuMqttSubscriptionsDo(Long.valueOf(this.idGenerator.nextId()), refreshRequest.getClientId(), refreshRequest.getNode(), refreshRequest.getQos(), refreshRequest.getTopic(), refreshRequest.getProductKey(), refreshRequest.getUpcommLogicAddr(), System.currentTimeMillis(), System.currentTimeMillis(), 1);
                this.timuMqttSubscriptionsDao.insert(timuMqttSubscriptionsDo);
            }
            returnResponse.setReturnResponseResult(TimuResponseResultEnum.SUCCESS);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end refreshTimuMqttSubscriptions <<<<<<< ");
        }
        return returnResponse;
    }

    public TimuMqttSubscriptionsGetResponse getTimuMqttSubscriptions(TimuMqttSubscriptionsGetRequest getRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start getTimuMqttSubscriptions >>>>>> ");
            this.logger.debug(" TimuMqttSubscriptionsGetRequest  : " + JsonConvertUtils.convertToString((Object)getRequest));
        }
        TimuMqttSubscriptionsGetResponse getResponse = new TimuMqttSubscriptionsGetResponse();
        getResponse.setReturnResponseResult(TimuResponseResultEnum.FAILURE);
        if (getRequest != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{getRequest.getProductKey(), getRequest.getUpcommLogicAddr()})) {
            HashMap params = Maps.newHashMap();
            params.put("productKey", getRequest.getProductKey());
            params.put("upcommLogicAddr", getRequest.getUpcommLogicAddr());
            List timuMqttSubscriptionsDoList = this.timuMqttSubscriptionsDao.getList(params, null, null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" TimuMqttSubscriptionsDoList : " + JsonConvertUtils.convertToString((Object)timuMqttSubscriptionsDoList));
            }
            if (timuMqttSubscriptionsDoList != null && timuMqttSubscriptionsDoList.size() > 0) {
                TimuMqttSubscriptionsDo TimuMqttSubscriptionsDo2 = (TimuMqttSubscriptionsDo)timuMqttSubscriptionsDoList.get(0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(" TimuMqttSubscriptionsDo : " + JsonConvertUtils.convertToString((Object)TimuMqttSubscriptionsDo2));
                }
                getResponse.setReturnResponseResult(TimuResponseResultEnum.SUCCESS);
                getResponse.setTimuMqttSubscriptionsDo(TimuMqttSubscriptionsDo2);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< end getTimuMqttSubscriptions <<<<<<< ");
        }
        return getResponse;
    }
}

