package com.iesms.bizprocessors.timuiotgateway.dao;

import com.iesms.bizprocessors.timuiotgateway.entity.TimuGmDevMeterDo;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuGmopsDevMeter;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuGmopsDevTermDo;
import org.apache.ibatis.annotations.Param;

import java.util.Map;

/**
 * @Description :根据地址查询表计地址
 * @Author : ghl
 * @Date: 2020-08-13 10:45
 */
public interface TimuDevMeterDao {
    /**
     * 根据通讯地址查询表计地址
     *
     * @param addr
     * @return
     */
    TimuGmDevMeterDo getDevMeterByDevMeterCommAddr(@Param("params") Map<String, String> params);

    /**
     * 根据终端地址查询终端标识
     *
     * @param params
     * @return
     */
    TimuGmopsDevTermDo getTimuGmopsDevTermByAddr(@Param("params") Map<String, String> params);

    /**
     * 更新终端状态
     *
     * @param gmopsDevTermDo
     */
    void insertOrUpdateTimuGmopsDevTerm(TimuGmopsDevTermDo gmopsDevTermDo);

    void insertOrUpdateTimuGmDevMeterDo(TimuGmopsDevMeter gmopsDevMeter);
}
