package com.iesms.bizprocessors.timuiotgateway.service.impl;

import com.iesms.bizprocessors.timuiotgateway.dao.TimuDevMeterDao;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuGmDevMeterDo;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuGmopsDevMeter;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuGmopsDevTermDo;
import com.iesms.bizprocessors.timuiotgateway.service.TimuDevMeterService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Description :
 * @Author : ghl
 * @Date: 2020-08-13 11:07
 */
@Service
public class TimuDevMeterServiceImpl extends AbstractBaseService implements TimuDevMeterService {
    @Resource
    private TimuDevMeterDao timuDevMeterDao;

    /**
     * 根据终端地址查询终端标识
     *
     * @param params
     * @return
     */
    @Override
    public TimuGmopsDevTermDo getTimuGmopsDevTermByAddr(Map<String, String> params) {
        return timuDevMeterDao.getTimuGmopsDevTermByAddr(params);
    }

    /**
     * 更新终端状态
     *
     * @param gmopsDevTermDo
     */
    @Override
    public void insertOrUpdateTimuGmopsDevTerm(TimuGmopsDevTermDo gmopsDevTermDo) {
        gmopsDevTermDo.setId(idGenerator.nextId());

        // IESMS_BP
        long currTime = System.currentTimeMillis();
        String create = "IESMS_BP";
        gmopsDevTermDo.setCreator(create);
        gmopsDevTermDo.setInvalider(create);
        gmopsDevTermDo.setModifier(create);
        gmopsDevTermDo.setGmtAlarmUp(currTime);
        gmopsDevTermDo.setGmtConnectedAt(currTime);
        gmopsDevTermDo.setGmtCreate(currTime);
        gmopsDevTermDo.setGmtHeartbeatUp(currTime);
        gmopsDevTermDo.setGmtInvalid(currTime);
        gmopsDevTermDo.setGmtMeasdataUp(currTime);
        gmopsDevTermDo.setGmtModified(currTime);
        gmopsDevTermDo.setGmtMessageUp(currTime);
        gmopsDevTermDo.setValid(true);
        timuDevMeterDao.insertOrUpdateTimuGmopsDevTerm(gmopsDevTermDo);
    }

    @Override
    public TimuGmDevMeterDo getDevMeterByDevMeterCommAddr(Map<String, String> params) {
        return timuDevMeterDao.getDevMeterByDevMeterCommAddr(params);
    }

    @Override
    public void insertOrUpdateTimuGmDevMeterDo(TimuGmopsDevMeter gmopsDevMeter) {
        if (gmopsDevMeter != null) {
            gmopsDevMeter.setId(idGenerator.nextId());
            gmopsDevMeter.setGmtCreate(System.currentTimeMillis());
            gmopsDevMeter.setGmtModified(System.currentTimeMillis());
            gmopsDevMeter.setVersion(1);
            timuDevMeterDao.insertOrUpdateTimuGmDevMeterDo(gmopsDevMeter);
        }

    }
}
