package com.iesms.bizprocessors.timuiotgateway.service.impl;


import com.easesource.commons.util.StringUtils;
import com.iesms.bizprocessors.timuiotgateway.dao.TimuMqttMessageDao;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuMqttDataCommonDo;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuMqttMessageDo;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttMessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author ghl
 */
@Service
public class TimuMqttMessageServiceImpl extends AbstractBaseService implements TimuMqttMessageService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private TimuMqttMessageDao mqttMessageDao;

    /**
     * 单条数据插入
     *
     * @param mqttDataCommonDo
     * @return
     */
    @Override
    public int insertOrUpdateTimuMqttSubscriptions(TimuMqttDataCommonDo mqttDataCommonDo) {
        TimuMqttMessageDo mqttMessageDo = mqttDataCommonDo.getMqttMessageDo();
        mqttMessageDo.setId(idGenerator.nextId());
        mqttMessageDo.setGmtCreate(System.currentTimeMillis());
        mqttMessageDo.setGmtModified(System.currentTimeMillis());
        mqttMessageDo.setClientId(mqttMessageDo.getReceivedMessageId());
        mqttMessageDo.setNode("mqtttest.ebike-charge.com");

        String topic = mqttMessageDo.getTopic();
        String[] topics = StringUtils.split(topic, "/");
        mqttMessageDo.setProductKey(topics[1]);
        mqttMessageDo.setUpcommLogicAddr(topics[2]);
        mqttMessageDo.setReceivedClientId(topics[2]);
        mqttMessageDo.setReceivedProductKey(topics[0]);
        mqttMessageDo.setVersion(1);
        try {
            mqttMessageDao.insertOrUpdateTimuMqttSubscriptions(mqttMessageDo);
        } catch (RuntimeException e) {
            logger.error("insertOrUpdateTimuMqttSubscriptions error:{}", e.getMessage());
            e.printStackTrace();
        }

        try {
            mqttMessageDao.insertOrUpdateTimuMqttmsgReceivedLog(mqttMessageDo);
        } catch (Exception e2) {
            logger.error("insertOrUpdateTimuMqttmsgReceivedLog error:{}", e2.getMessage());
            e2.printStackTrace();
        }
        return 1;
    }
}
