package com.iesms.bizprocessors.timuiotgateway.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.timuiotgateway.constant.TimuResponseResultEnum;
import com.iesms.bizprocessors.timuiotgateway.dao.TimuMqttSubscriptionsDao;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuMqttSubscriptionsDo;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttSubscriptionsGetRequest;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttSubscriptionsRefreshRequest;
import com.iesms.bizprocessors.timuiotgateway.response.TimuMqttSubscriptionsGetResponse;
import com.iesms.bizprocessors.timuiotgateway.response.TimuReturnResponse;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttSubscriptionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author ghl
 */
@Service
public class TimuMqttSubscriptionsServiceImpl extends AbstractBaseService implements TimuMqttSubscriptionsService {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private TimuMqttSubscriptionsDao timuMqttSubscriptionsDao;

    @Override
    public TimuReturnResponse refreshTimuMqttSubscriptions(TimuMqttSubscriptionsRefreshRequest refreshRequest) {
        if (logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start refreshTimuMqttSubscriptions >>>>>> ");
            logger.debug(" TimuMqttSubscriptionsRefreshRequest  : " + JsonConvertUtils.convertToString(refreshRequest));
        }
        TimuReturnResponse returnResponse = new TimuReturnResponse();
        if (refreshRequest != null && StringUtils.isAllBlank(refreshRequest.getClientId(), refreshRequest.getTopic())) {
            TimuMqttSubscriptionsDo timuMqttSubscriptionsDo = timuMqttSubscriptionsDao.getByClientIdAndTopic(refreshRequest.getClientId(), refreshRequest.getTopic());
            if (timuMqttSubscriptionsDo != null) {
                // update
                timuMqttSubscriptionsDo.setGmtModified(System.currentTimeMillis());
                timuMqttSubscriptionsDao.updateByClientIdAndTopic(timuMqttSubscriptionsDo);
            } else {
                /// insert
                timuMqttSubscriptionsDo = new TimuMqttSubscriptionsDo(idGenerator.nextId(),
                        refreshRequest.getClientId(),
                        refreshRequest.getNode(),
                        refreshRequest.getQos(),
                        refreshRequest.getTopic(),
                        refreshRequest.getProductKey(),
                        refreshRequest.getUpcommLogicAddr(),
                        System.currentTimeMillis(),
                        System.currentTimeMillis(),
                        1
                );
                timuMqttSubscriptionsDao.insert(timuMqttSubscriptionsDo);
            }
            returnResponse.setReturnResponseResult(TimuResponseResultEnum.SUCCESS);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end refreshTimuMqttSubscriptions <<<<<<< ");
        }
        return returnResponse;
    }

    @Override
    public TimuMqttSubscriptionsGetResponse getTimuMqttSubscriptions(TimuMqttSubscriptionsGetRequest getRequest) {

        if (logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getTimuMqttSubscriptions >>>>>> ");
            logger.debug(" TimuMqttSubscriptionsGetRequest  : " + JsonConvertUtils.convertToString(getRequest));
        }
        
        TimuMqttSubscriptionsGetResponse getResponse = new TimuMqttSubscriptionsGetResponse();
        getResponse.setReturnResponseResult(TimuResponseResultEnum.FAILURE);
        if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getUpcommLogicAddr())) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("productKey", getRequest.getProductKey());
            params.put("upcommLogicAddr", getRequest.getUpcommLogicAddr());
            List<TimuMqttSubscriptionsDo> timuMqttSubscriptionsDoList = timuMqttSubscriptionsDao.getList(params, null, null);
            if(logger.isDebugEnabled()) {
                logger.debug(" TimuMqttSubscriptionsDoList : " + JsonConvertUtils.convertToString(timuMqttSubscriptionsDoList));
            }
            if(timuMqttSubscriptionsDoList != null && timuMqttSubscriptionsDoList.size() > 0) {
                TimuMqttSubscriptionsDo TimuMqttSubscriptionsDo = timuMqttSubscriptionsDoList.get(0);
                if(logger.isDebugEnabled()) {
                    logger.debug(" TimuMqttSubscriptionsDo : " + JsonConvertUtils.convertToString(TimuMqttSubscriptionsDo));
                }
                getResponse.setReturnResponseResult(TimuResponseResultEnum.SUCCESS);
                getResponse.setTimuMqttSubscriptionsDo(TimuMqttSubscriptionsDo);
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< end getTimuMqttSubscriptions <<<<<<< ");
        }
        return getResponse;
    }
}
