package com.iesms.bizprocessors.timuiotgateway.service.impl;

import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.bizprocessors.timuiotgateway.constant.TimuResponseResultEnum;
import com.iesms.bizprocessors.timuiotgateway.dao.TimuMqttmsgPublishLogDao;
import com.iesms.bizprocessors.timuiotgateway.dao.TimuMqttmsgReceivedLogDao;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuMqttmsgPublishLogDo;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuMqttmsgReceivedLogDo;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttmsgPublishLogInsertRequest;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttmsgReceivedLogInsertRequest;
import com.iesms.bizprocessors.timuiotgateway.response.TimuReturnResponse;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttmsgLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author ghl
 */
@Service
public class TimuMqttmsgLogServiceImpl extends AbstractBaseService implements TimuMqttmsgLogService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private TimuMqttmsgReceivedLogDao timuMqttmsgReceivedLogDao;

    @Resource
    private TimuMqttmsgPublishLogDao timuMqttmsgPublishLogDao;

    /**
     * 插入接收MQTT消息报文
     *
     * @param  插入接收MQTT消息报文请求
     * @return 插入接收MQTT消息报文回应
     */
    @Override
    public TimuReturnResponse insertTimuMqttmsgReceivedLog(TimuMqttmsgReceivedLogInsertRequest insertRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start insertTimuMqttmsgReceivedLog >>>>>> ");
            logger.debug(" TimuMqttmsgReceivedLogInsertRequest  : " + JsonConvertUtils.convertToString(insertRequest));
        }
        TimuReturnResponse returnResponse = new TimuReturnResponse();
        returnResponse.setReturnResponseResult(TimuResponseResultEnum.FAILURE);
        if(insertRequest != null) {
            TimuMqttmsgReceivedLogDo receivedLog = new TimuMqttmsgReceivedLogDo(
                    idGenerator.nextId(),
                    insertRequest.getPayload(),
                    insertRequest.getTopic(),
                    insertRequest.getTopic(),
                    insertRequest.getQos(),
                    insertRequest.isRetained(),
                    insertRequest.isDuplicate(),
                    insertRequest.getReceivedProductKey(),
                    insertRequest.getReceivedClientId(),
                    insertRequest.getReceivedMessageId(),
                    ObjectUtils.defaultIfNull(insertRequest.getReceivedMessageTimestamp(), System.currentTimeMillis())
            );
            int result = timuMqttmsgReceivedLogDao.insertLog(receivedLog);
            if(result > 0) {
                returnResponse.setReturnResponseResult(TimuResponseResultEnum.SUCCESS);
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" ReturnResponse  : " + JsonConvertUtils.convertToString(returnResponse));
            logger.debug(" <<<<<<< end insertTimuMqttmsgReceivedLog <<<<<<< ");
        }
        return returnResponse;
    }

    /**
     * 插入发布MQTT消息报文
     *
     * @param insertRequest 插入发布MQTT消息报文请求
     * @return 插入发布MQTT消息报文回应
     */
    @Override
    public TimuReturnResponse insertTimuMqttmsgPublishLog(TimuMqttmsgPublishLogInsertRequest insertRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start insertTimuMqttmsgPublishLog >>>>>> ");
            logger.debug(" TimuMqttmsgPublishLogInsertRequest  : " + JsonConvertUtils.convertToString(insertRequest));
        }
        TimuReturnResponse returnResponse = new TimuReturnResponse();
        returnResponse.setReturnResponseResult(TimuResponseResultEnum.FAILURE);
        if(insertRequest != null) {
            TimuMqttmsgPublishLogDo publishLog = new TimuMqttmsgPublishLogDo(
                    idGenerator.nextId(),
                    insertRequest.getPayload(),
                    null,
                    insertRequest.getTopic(),
                    insertRequest.getQos(),
                    insertRequest.isRetained(),
                    insertRequest.isDuplicate(),
                    insertRequest.getPublishProductKey(),
                    insertRequest.getPublishClientId(),
                    System.currentTimeMillis()
            );
            int result = timuMqttmsgPublishLogDao.insertLog(publishLog);
            if(result > 0) {
                returnResponse.setReturnResponseResult(TimuResponseResultEnum.SUCCESS);
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" ReturnResponse  : " + JsonConvertUtils.convertToString(returnResponse));
            logger.debug(" <<<<<<< end insertTimuMqttmsgPublishLog <<<<<<< ");
        }
        return returnResponse;
    }

    @Override
    public void insertOrUpdateTimuMqttmsgReceivedValueLog(TimuMqttmsgReceivedLogDo insertRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start insertOrUpdateTimuMqttmsgReceivedValueLog >>>>>> ");
            logger.debug(" TimuMqttmsgPublishLogInsertRequest  : " + JsonConvertUtils.convertToString(insertRequest));
        }

        insertRequest.setId(idGenerator.nextId());
        insertRequest.setGmtCreate(System.currentTimeMillis());
        insertRequest.setQos(1);
        insertRequest.setDuplicate(false);

        timuMqttmsgReceivedLogDao.insertOrUpdateTimuMqttmsgReceivedValueLog(insertRequest);
    }
}
