/*
 * Decompiled with CFR 0.152.
 */
package com.gaea.base.core;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gaea.base.core.IBaseEnum;
import com.gaea.base.dto.Dto;
import com.gaea.base.enums.CommonCodeEnum;
import com.gaea.base.error.BizException;
import com.gaea.base.vo.PageDataVo;
import io.swagger.annotations.ApiModelProperty;
import java.beans.Transient;

public class R<T>
implements Dto<T> {
    private static final long serialVersionUID = 7320469262382813175L;
    @ApiModelProperty(value="\u72b6\u6001\u7801")
    private final Integer code;
    @ApiModelProperty(value="\u63d0\u793a\u4fe1\u606f")
    private String msg;
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e")
    private final T data;

    public R() {
        this.code = CommonCodeEnum.SUCCESS.getValue();
        this.msg = CommonCodeEnum.SUCCESS.getName();
        this.data = null;
    }

    public R(Integer code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    private R(IBaseEnum<Integer> iBaseEnum, T data) {
        this.code = iBaseEnum.getValue();
        this.msg = iBaseEnum.getName();
        this.data = data;
    }

    @Transient
    public Boolean isSuccess() {
        return CommonCodeEnum.SUCCESS.getValue().equals(this.code) && this.data != null;
    }

    public static <T> R<T> ok() {
        return new R<Object>(CommonCodeEnum.SUCCESS, null);
    }

    public static <T> R<T> ok(T data) {
        return new R<T>(CommonCodeEnum.SUCCESS, data);
    }

    public static <T> R<T> failure() {
        return new R<Object>(CommonCodeEnum.REQUEST_FAILURE, null);
    }

    public static <T> R<T> failure(T data) {
        return new R<T>(CommonCodeEnum.REQUEST_FAILURE, data);
    }

    public static <T> R<PageDataVo<T>> ok(IPage<T> iPage) {
        PageDataVo vo = new PageDataVo(iPage.getCurrent(), iPage.getSize(), iPage.getTotal(), iPage.getPages(), iPage.getRecords());
        return R.ok(vo);
    }

    public static <T> R<T> enums(IBaseEnum<Integer> iBaseEnum) {
        return new R<Object>(iBaseEnum, null);
    }

    public static R<BizException> biz(BizException e) {
        return new R<Object>(e.getCode(), e.getMsg(), null);
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public T getData() {
        return this.data;
    }

    public <T> R<T> msg(String msg) {
        this.msg = msg;
        return this;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

