package com.gaea.spring.cloud.starter.component.swagger.config;

import com.gaea.base.enums.CommonCodeEnum;
import com.gaea.spring.cloud.starter.component.swagger.property.SwaggerProperties;
import com.google.common.collect.Lists;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.*;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.*;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/11/24
 */
@Configuration
@EnableSwagger2WebMvc
@SuppressWarnings("all")
public class SwaggerConfig {

    @Resource
    private SwaggerProperties swaggerProperties;

    @Bean(value = "userApi")
    @Order(value = 1)
    public Docket groupRestApi() {
        /**
         * 密码模式
         */
        List<GrantType> grantTypes = new ArrayList<>();
        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = new ResourceOwnerPasswordCredentialsGrant(swaggerProperties.getOauth());
        grantTypes.add(resourceOwnerPasswordCredentialsGrant);
        OAuth oAuth = new OAuthBuilder().name("oauth2").grantTypes(grantTypes).build();
        List<AuthorizationScope> scopes = new ArrayList<>();
        scopes.add(new AuthorizationScope("all", "all"));
        SecurityReference securityReference = new SecurityReference("oauth2", scopes.toArray(new AuthorizationScope[]{}));
        SecurityContext securityContext = new SecurityContext(Lists.newArrayList(securityReference), PathSelectors.ant("/api/**"));
        List<SecurityScheme> securitySchemes = Lists.newArrayList(oAuth);
        List<SecurityContext> securityContexts = Lists.newArrayList(securityContext);

        List<ResponseMessage> messageList = getGlobalResponse();

        return new Docket(DocumentationType.SWAGGER_2)
                .globalResponseMessage(RequestMethod.GET, messageList)
                .globalResponseMessage(RequestMethod.POST, messageList)
                .globalResponseMessage(RequestMethod.PUT, messageList)
                .globalResponseMessage(RequestMethod.DELETE, messageList)
                .host(swaggerProperties.getHost())
                .apiInfo(groupApiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage(swaggerProperties.getPackageLocal()))
                .paths(PathSelectors.any())
                .build()
                .securityContexts(securityContexts)
                .securitySchemes(securitySchemes);
    }

    private ApiInfo groupApiInfo() {
        return new ApiInfoBuilder()
                .title(swaggerProperties.getProjectName())
                .description("<div style='font-size:14px;color:red;'>" + swaggerProperties.getIntro() + "</div>")
                .termsOfServiceUrl(swaggerProperties.getUrl())
                .contact(new Contact(swaggerProperties.getAuthor(), "", ""))
                .version(swaggerProperties.getVersion())
                .build();
    }

    private static List<ResponseMessage> getGlobalResponse() {
        List<ResponseMessage> messageList = new ArrayList<>();
//        Arrays.stream(CommonCodeEnum.values()).forEach(item -> {
//            messageList.add(new ResponseMessageBuilder().code(item.getValue()).message(item.getName()).responseModel(new ModelRef(item.getName())).build());
//        });
        return messageList;
    }
}
