package com.gaea.spring.cloud.starter.controller;

import com.gaea.utils.StringUtils;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2024/5/28
 */
@RestController
@RequestMapping("runLog")
public class RunLogController {

    @Resource
    private ResourceLoader resourceLoader;

    @GetMapping("getStdoutLog")
    public void getStdoutLog(HttpServletResponse response, String size) throws IOException {
        RandomAccessFile randomAccessFile = null;
        OutputStream outputStream = response.getOutputStream();
        try {
            // 设置响应类型和编码
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());

            // 示例：设置响应头，指示文件名，以便于浏览器下载而不是直接打开
            String fileName = "stdout.log";
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);

            org.springframework.core.io.Resource resource = resourceLoader.getResource("file:.logs/stdout.log");
            File file = resource.getFile();

            // 计算要读取的起始位置
            long fileSize = file.length();
            long startPosition = Math.max(0, fileSize - 512 * 1024);
            if (StringUtils.equals(size, "all")) {
                startPosition = 0;
            }

            // 使用RandomAccessFile读取文件内容
            randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.seek(startPosition);

            byte[] buffer = new byte[1024];
            int bytesRead;
            while ((bytesRead = randomAccessFile.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        } catch (Exception e) {
            outputStream.write(e.getMessage().getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        } finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }
}
