package com.gaea.spring.cloud.starter.util;

import cn.hutool.json.JSONUtil;
import com.gaea.spring.cloud.starter.context.HttpContext;
import com.gaea.spring.cloud.starter.vo.UserDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URLDecoder;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2022/5/12
 */
public class AuthUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUtils.class);

    /**
     * 用户标识
     */
    public static Long getUserId() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? null : userDetail.getUserId();
    }

    /**
     * 用户编号
     */
    public static String getUserNo() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getUserNo();
    }

    /**
     * 用户全名
     */
    public static String getUserFullname() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getUserFullname();
    }

    /**
     * 用户昵称
     */
    public static String getUserNickname() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getUserNickname();
    }

    /**
     * 用户头像
     */
    public static String getUserHeadPhoto() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getUserHeadPhoto();
    }

    /**
     * 用户手机
     */
    public static String getUserMobile() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getUserMobile();
    }

    /**
     * 用户邮箱
     */
    public static String getUserEmail() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getUserEmail();
    }

    /**
     * 一级业务单位编号
     */
    public static String getPrimaryOrgNo() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getPrimaryOrgNo();
    }

    /**
     * 单位编号
     */
    public static String getOrgNo() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getOrgNo();
    }

    /**
     * 单位名称
     */
    public static String getOrgName() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getOrgName();
    }

    /**
     * 单位简称
     */
    public static String getOrgAbbr() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getOrgAbbr();
    }

    /**
     * 单位说明
     */
    public static String getOrgDesc() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getOrgDesc();
    }

    /**
     * 单位层级
     */
    public static Integer getOrgLevel() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? -1 : userDetail.getOrgLevel();
    }

    /**
     * 部门编号
     */
    public static String getDeptNo() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getDeptNo();
    }

    /**
     * 部门名称
     */
    public static String getDeptName() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getDeptName();
    }

    /**
     * 部门简称
     */
    public static String getDeptAbbr() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getDeptAbbr();
    }

    /**
     * 部门说明
     */
    public static String getDeptDesc() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? "" : userDetail.getDeptDesc();
    }

    /**
     * 部门层级
     */
    public static Integer getDeptLevel() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? null : userDetail.getDeptLevel();
    }

    /**
     * 上级单位
     */
    public static String getParentOrgNo() {
        UserDetail userDetail = getUserDetail();
        return userDetail == null ? null : userDetail.getParentOrgNo();
    }

    /**
     * 用户信息
     */
    public static UserDetail getUserDetail() {
        try {
            String user = HttpContext.getRequest().getHeader("user");
            user = URLDecoder.decode(user, "UTF-8");
            return JSONUtil.parseObj(user).toBean(UserDetail.class);
        } catch (Exception e) {
//            LOGGER.error(">>> 获取用户信息失败 : {}", e.getMessage());
        }
        return null;
    }
}
