package com.easesource.iot.springbootapps.datacenter.config;

import com.easesource.data.id.generator.IdGenerator;
import com.easesource.iot.datacenter.base.generator.EaseIotDataIdGenerator;
import com.easesource.iot.datacenter.base.generator.EaseIotDeviceIdGenerator;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

/**
 * @author Nick Zhang
 * @date 2019-03-11
 */
@Configuration
public class IdGeneratorConfig {

    @Scope(value = ConfigurableBeanFactory.SCOPE_SINGLETON)
    @Bean(name = "iotDeviceIdGenerator")
    @Qualifier("iotDeviceIdGenerator")
    IdGenerator iotDeviceIdGenerator() {
        return new EaseIotDeviceIdGenerator();
    }

    @Scope(value = ConfigurableBeanFactory.SCOPE_SINGLETON)
    @Bean(name = "iotDataIdGenerator")
    @Qualifier("iotDataIdGenerator")
    IdGenerator iotDataIdGenerator() {
        return new EaseIotDataIdGenerator();
    }

}
