package com.easesource.iot.springbootapps.datacenter.config;

import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;

/**
 * @author Nick Zhang
 * @date 2019-02-28
 */
@Configuration
@MapperScan(basePackages = {"com.easesource.iot.datacenter.openservice.dao"}, sqlSessionTemplateRef = "easeiotSqlSessionTemplate")
public class EaseIotMyBatisSqlSessionConfig {

    @Bean(name = "easeiotSqlSessionFactory")
    @Qualifier("easeiotSqlSessionFactory")
    @Primary
    public SqlSessionFactory easeiotSqlSessionFactory(@Qualifier("easeiotDataSource") DataSource easeiotDataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        org.apache.ibatis.session.Configuration mybatisGlobalConfiguration = new org.apache.ibatis.session.Configuration();
        mybatisGlobalConfiguration.setCallSettersOnNulls(true);
        mybatisGlobalConfiguration.setMapUnderscoreToCamelCase(true);
        bean.setConfiguration(mybatisGlobalConfiguration);
        bean.setDataSource(easeiotDataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:easeiot/datacenter/mybatis/mapper/*.xml"));
        return bean.getObject();
    }

    @Bean(name = "easeiotSqlSessionTemplate")
    @Qualifier("easeiotSqlSessionTemplate")
    @Primary
    public SqlSessionTemplate easeiotSqlSessionTemplate(@Qualifier("easeiotSqlSessionFactory") SqlSessionFactory easeiotSqlSessionFactory) {
        return new SqlSessionTemplate(easeiotSqlSessionFactory);
    }

}
