package com.easesource.iot.springbootapps.datacenter.controller;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.base.ResponseResult;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * <p>url : /api/dmg/iotmd/measdata</p>
 */
@RestController
@RequestMapping(value = "/api/dmg/iotmd/measdata")
public class MeasDataApiController {

    private static final Logger logger = LoggerFactory.getLogger(MeasDataApiController.class);

    @Resource(name = "measDataService")
    private MeasDataService measDataService;

    @PostMapping(value = "/analog/curve")
    public Mono<ResponseEntity<ResponseResult>> getAnalogCurve(@RequestBody Map<String, Object> params) {
        if(logger.isDebugEnabled()) {
            logger.debug(" params : " + JsonConvertUtils.convertToString(params));
        }
        return Mono.just(new ResponseEntity<>(ResponseResult.failure(), HttpStatus.OK));
    }

}
