package com.easesource.iot.springbootapps.datacenter.task;

import com.easesource.iot.datacenter.openservice.entity.MeasDataTaskDo;
import org.quartz.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class QuartzManager {


    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private Scheduler scheduler;

    /**
     * 添加任务
     * 第一层String是taskType, 内层Map的key是corn表达式
     */
    public void addJob(Map<String, Map<String, List<MeasDataTaskDo>>> map) {
        try {
            Set<String> taskTypeSet = map.keySet();
            for (String taskType : taskTypeSet) {
                Map<String, List<MeasDataTaskDo>> groupByCorn = map.get(taskType);
                Set<String> groupByCornSet = groupByCorn.keySet();
                for (String cron : groupByCornSet) {
                    List<MeasDataTaskDo> taskList = groupByCorn.get(cron);
                    MeasDataTaskDo task = taskList.get(0);
                    Set<String> orgNoSet = taskList.stream().map(MeasDataTaskDo::getOrgNo).collect(Collectors.toSet());
                    //处理
                    Class<? extends Job> jobClass = (Class<? extends Job>) (Class.forName(task.getClazzName()).newInstance()
                        .getClass());
                    if (jobClass != null) {
                        JobDetail jobDetail = JobBuilder.newJob(jobClass)
                            .build();
                        jobDetail.getJobDataMap().put("orgNoSet", orgNoSet);
                        // 定义调度触发规则
                        // 使用cornTrigger规则
                        Trigger trigger = TriggerBuilder.newTrigger()
                            .startAt(DateBuilder.futureDate(1, DateBuilder.IntervalUnit.SECOND))
                            .withSchedule(CronScheduleBuilder.cronSchedule(cron)).startNow().build();
                        scheduler.scheduleJob(jobDetail, trigger);
                        // 启动
                        if (!scheduler.isShutdown()) {
                            scheduler.start();
                        }
                    }
                }
            }
        } catch (Exception e) {
            logger.error("加载动态定时任务错误：", e);
        }

    }
}
