package com.easesource.iot.springbootapps.datacenter.controller;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.MeasStatService;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumDayGetRangeRequest;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumDayGetRangeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;

/**
 *
 * @author Nick Zhang
 * <p>url : /api/dmg/iotmd/measstat</p>
 */
@RestController
@RequestMapping(value = "/api/dmg/iotmd/measstat")
public class MeasStatApiController {

    private static final Logger logger = LoggerFactory.getLogger(MeasStatApiController.class);

    @Resource(name = "measStatService")
    private MeasStatService measStatService;

    @GetMapping(value = "/get-range-meas-stat-cum-day")
    public Mono<ResponseEntity<MeasStatCumDayGetRangeResponse>> getRangeMeasStatCumDay(MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getRangeMeasStatCumDay >>>>>> ");
            logger.debug(" MeasStatCumDayGetRangeRequest : {} " + JsonConvertUtils.convertToString(measStatCumDayGetRangeRequest));
        }
        MeasStatCumDayGetRangeResponse measStatCumDayGetRangeResponse = measStatService.getRangeMeasStatCumDay(measStatCumDayGetRangeRequest);
        return Mono.just(new ResponseEntity<>(measStatCumDayGetRangeResponse, HttpStatus.OK));
    }

}
