package com.easesource.iot.springbootapps.datacenter.config;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * @author Nick Zhang
 */
@Configuration
public class EaseIotDataSourceConfig {

    @Bean(name = "easeiotDataSource")
    @Qualifier("easeiotDataSource")
    @Primary
    @ConfigurationProperties(prefix = "spring.datasource.hikari.easeiot")
    DataSource easeiotDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Bean(name = "easeiotTransactionManager")
    @Qualifier("easeiotTransactionManager")
    @Primary
    public DataSourceTransactionManager easeiotTransactionManager(@Qualifier("easeiotDataSource") DataSource easeiotDataSource) {
        return new DataSourceTransactionManager(easeiotDataSource);
    }

}
